/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import jodd.db.DbSession;
import jodd.db.DbSessionProvider;
import jodd.db.DbSqlException;
import jodd.db.DbThreadSession;
import jodd.db.ThreadDbSessionHolder;
import jodd.log.Log;

public class ThreadDbSessionProvider
implements DbSessionProvider {
    private static final Log log = Log.getLogger(ThreadDbSessionProvider.class);
    protected final boolean createIfMissing;

    public ThreadDbSessionProvider() {
        this(false);
    }

    public ThreadDbSessionProvider(boolean createIfMissing) {
        this.createIfMissing = createIfMissing;
    }

    public DbSession getDbSession() {
        DbSession session;
        if (log.isDebugEnabled()) {
            log.debug("Requesting thread session");
        }
        if ((session = ThreadDbSessionHolder.get()) == null) {
            if (this.createIfMissing) {
                return new DbThreadSession();
            }
            throw new DbSqlException("No session associated to current thread.");
        }
        return session;
    }

    public void closeDbSession() {
        ThreadDbSessionProvider.closeThreadDbSession();
    }

    public static void closeThreadDbSession() {
        DbSession session;
        if (log.isDebugEnabled()) {
            log.debug("Closing thread session");
        }
        if ((session = ThreadDbSessionHolder.get()) != null) {
            session.closeSession();
        }
    }
}

