/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom;

import java.lang.reflect.Field;
import java.util.ArrayList;
import jodd.db.oom.DbEntityColumnDescriptor;
import jodd.db.oom.DbMetaUtil;
import jodd.db.oom.DbOomException;
import jodd.db.oom.naming.ColumnNamingStrategy;
import jodd.db.oom.naming.TableNamingStrategy;
import jodd.introspector.ClassIntrospector;
import jodd.util.FastSort;

public class DbEntityDescriptor {
    private final Class type;
    private final String entityName;
    private final boolean isAnnotated;
    private final String tableName;
    private final String schemaName;
    private final ColumnNamingStrategy columnNamingStrategy;
    private final boolean strictCompare;
    private DbEntityColumnDescriptor[] columnDescriptors;
    private DbEntityColumnDescriptor[] idColumnDescriptors;

    public DbEntityDescriptor(Class type, String schemaName, TableNamingStrategy tableNamingStrategy, ColumnNamingStrategy columnNamingStrategy, boolean strictCompare) {
        this.type = type;
        this.entityName = type.getSimpleName();
        this.isAnnotated = DbMetaUtil.resolveIsAnnotated(type);
        this.schemaName = DbMetaUtil.resolveSchemaName(type, schemaName);
        this.tableName = DbMetaUtil.resolveTableName(type, tableNamingStrategy);
        this.columnNamingStrategy = columnNamingStrategy;
        this.strictCompare = strictCompare;
    }

    public Class getType() {
        return this.type;
    }

    public boolean isAnnotated() {
        return this.isAnnotated;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public DbEntityColumnDescriptor[] getColumnDescriptors() {
        this.init();
        return this.columnDescriptors;
    }

    protected void init() {
        if (this.columnDescriptors == null) {
            this.resolveColumnsAndProperties(this.type);
        }
    }

    private void resolveColumnsAndProperties(Class type) {
        Field[] fields = ClassIntrospector.lookup((Class)type).getAllFields(true);
        ArrayList<DbEntityColumnDescriptor> decList = new ArrayList<DbEntityColumnDescriptor>(fields.length);
        int idcount = 0;
        for (Field field : fields) {
            DbEntityColumnDescriptor dec = DbMetaUtil.resolveColumnDescriptors(this, field, this.isAnnotated, this.columnNamingStrategy);
            if (dec == null) continue;
            decList.add(dec);
            if (!dec.isId) continue;
            ++idcount;
        }
        if (decList.isEmpty()) {
            throw new DbOomException("Entity '" + type + "' doesn't have any column mappings.");
        }
        this.columnDescriptors = decList.toArray(new DbEntityColumnDescriptor[decList.size()]);
        FastSort.sort((Comparable[])this.columnDescriptors);
        if (idcount > 0) {
            this.idColumnDescriptors = new DbEntityColumnDescriptor[idcount];
            idcount = 0;
            for (DbEntityColumnDescriptor dec : this.columnDescriptors) {
                if (!dec.isId) continue;
                this.idColumnDescriptors[idcount++] = dec;
            }
        }
    }

    public DbEntityColumnDescriptor findByColumnName(String columnName) {
        if (columnName == null) {
            return null;
        }
        this.init();
        if (this.strictCompare) {
            for (DbEntityColumnDescriptor columnDescriptor : this.columnDescriptors) {
                if (!columnDescriptor.columnName.equals(columnName)) continue;
                return columnDescriptor;
            }
        } else {
            for (DbEntityColumnDescriptor columnDescriptor : this.columnDescriptors) {
                if (!columnDescriptor.columnName.equalsIgnoreCase(columnName)) continue;
                return columnDescriptor;
            }
        }
        return null;
    }

    public DbEntityColumnDescriptor findByPropertyName(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        this.init();
        for (DbEntityColumnDescriptor columnDescriptor : this.columnDescriptors) {
            if (!columnDescriptor.propertyName.equals(propertyName)) continue;
            return columnDescriptor;
        }
        return null;
    }

    public String getPropertyName(String columnName) {
        DbEntityColumnDescriptor dec = this.findByColumnName(columnName);
        return dec == null ? null : dec.propertyName;
    }

    public String getColumnName(String propertyName) {
        DbEntityColumnDescriptor dec = this.findByPropertyName(propertyName);
        return dec == null ? null : dec.columnName;
    }

    public int getColumnsCount() {
        this.init();
        return this.columnDescriptors.length;
    }

    public int getIdColumnsCount() {
        this.init();
        return this.idColumnDescriptors == null ? 0 : this.idColumnDescriptors.length;
    }

    private void ensureSingleIdColumn() {
        this.init();
        if (this.idColumnDescriptors == null) {
            throw new DbOomException("Entity '" + this.entityName + "' has no identity column.");
        }
        if (this.idColumnDescriptors.length > 1) {
            throw new DbOomException("Entity '" + this.entityName + "' has more then one (" + this.idColumnDescriptors.length + ") identity columns.");
        }
    }

    public String getIdColumnName() {
        this.ensureSingleIdColumn();
        return this.idColumnDescriptors[0].getColumnName();
    }

    public String getIdPropertyName() {
        this.ensureSingleIdColumn();
        return this.idColumnDescriptors[0].getPropertyName();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DbEntity: ");
        if (this.schemaName != null) {
            sb.append(this.schemaName);
            sb.append('.');
        }
        sb.append(this.tableName);
        return sb.toString();
    }
}

