/*
 * Decompiled with CFR 0.152.
 */
package jodd.jtx.worker;

import jodd.jtx.JtxTransaction;
import jodd.jtx.JtxTransactionManager;
import jodd.jtx.JtxTransactionMode;
import jodd.log.Log;

public class LeanJtxWorker {
    private static final Log log = Log.getLogger(LeanJtxWorker.class);
    protected final JtxTransactionManager txManager;

    public LeanJtxWorker(JtxTransactionManager txManager) {
        this.txManager = txManager;
    }

    public JtxTransactionManager getTransactionManager() {
        return this.txManager;
    }

    public JtxTransaction getCurrentTransaction() {
        return this.txManager.getTransaction();
    }

    public JtxTransaction maybeRequestTransaction(JtxTransactionMode txMode, Object scope) {
        JtxTransaction requestedTx;
        if (txMode == null) {
            return null;
        }
        JtxTransaction currentTx = this.txManager.getTransaction();
        if (currentTx == (requestedTx = this.txManager.requestTransaction(txMode, scope))) {
            return null;
        }
        return requestedTx;
    }

    public boolean maybeCommitTransaction(JtxTransaction tx) {
        if (tx == null) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("commit tx");
        }
        tx.commit();
        return true;
    }

    public boolean markOrRollbackTransaction(JtxTransaction tx, Throwable cause) {
        if (tx == null) {
            tx = this.getCurrentTransaction();
            if (tx == null) {
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug("set rollback only tx");
            }
            tx.setRollbackOnly(cause);
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("rollback tx");
        }
        tx.rollback();
        return true;
    }
}

