/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import jodd.io.FileUtil;
import jodd.io.StreamUtil;
import jodd.log.Log;
import jodd.proxetta.Proxetta;
import jodd.proxetta.ProxettaException;
import jodd.proxetta.asm.TargetClassInfoReader;
import jodd.proxetta.asm.WorkData;
import jodd.util.ClassLoaderUtil;
import jodd.util.StringUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public abstract class ProxettaBuilder {
    private static final Log log = Log.getLogger(ProxettaBuilder.class);
    protected final Proxetta proxetta;
    private InputStream targetInputStream;
    private Class targetClass;
    private String targetClassName;
    protected String requestedProxyClassName;
    protected static int suffixCounter;
    protected ClassWriter destClassWriter;
    protected boolean proxyApplied;
    protected String proxyClassName;

    protected ProxettaBuilder(Proxetta proxetta) {
        this.proxetta = proxetta;
    }

    public void setTargetProxyClassName(String targetProxyClassName) {
        this.requestedProxyClassName = targetProxyClassName;
    }

    protected void setTarget(InputStream target) {
        this.checkTarget();
        this.targetInputStream = target;
        this.targetClass = null;
        this.targetClassName = null;
    }

    protected void setTarget(String targetName) {
        this.checkTarget();
        try {
            this.targetInputStream = ClassLoaderUtil.getClassAsStream((String)targetName);
            this.targetClassName = targetName;
            this.targetClass = null;
        }
        catch (IOException ioex) {
            StreamUtil.close((InputStream)this.targetInputStream);
            throw new ProxettaException("Unable to stream class name: " + targetName, ioex);
        }
    }

    protected void setTarget(Class target) {
        this.checkTarget();
        try {
            this.targetInputStream = ClassLoaderUtil.getClassAsStream((Class)target);
            this.targetClass = target;
            this.targetClassName = target.getName();
        }
        catch (IOException ioex) {
            StreamUtil.close((InputStream)this.targetInputStream);
            throw new ProxettaException("Unable to stream class: " + target.getName(), ioex);
        }
    }

    private void checkTarget() {
        if (this.targetInputStream != null) {
            throw new ProxettaException("Target already defined");
        }
    }

    protected String resolveClassNameSuffix() {
        String classNameSuffix = this.proxetta.getClassNameSuffix();
        if (classNameSuffix == null) {
            return null;
        }
        if (!this.proxetta.isVariableClassName()) {
            return classNameSuffix;
        }
        return classNameSuffix + ++suffixCounter;
    }

    protected abstract WorkData process(ClassReader var1, TargetClassInfoReader var2);

    protected void process() {
        ClassReader classReader;
        if (this.targetInputStream == null) {
            throw new ProxettaException("Target not defined");
        }
        try {
            classReader = new ClassReader(this.targetInputStream);
        }
        catch (IOException ioex) {
            throw new ProxettaException("Error reading class input stream.", ioex);
        }
        TargetClassInfoReader targetClassInfoReader = new TargetClassInfoReader();
        classReader.accept((ClassVisitor)targetClassInfoReader, 0);
        this.destClassWriter = new ClassWriter(3);
        if (log.isDebugEnabled()) {
            log.debug("processing: " + classReader.getClassName());
        }
        WorkData wd = this.process(classReader, targetClassInfoReader);
        this.proxyApplied = wd.proxyApplied;
        this.proxyClassName = wd.thisReference.replace('/', '.');
    }

    public byte[] create() {
        this.process();
        byte[] result = this.toByteArray();
        this.dumpClass(result);
        if (!this.proxetta.isForced() && !this.isProxyApplied()) {
            if (log.isDebugEnabled()) {
                log.debug("proxy not applied " + StringUtil.toSafeString((Object)this.targetClassName));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("proxy created " + StringUtil.toSafeString((Object)this.targetClassName));
        }
        return result;
    }

    public Class define() {
        this.process();
        if (!this.proxetta.isForced() && !this.isProxyApplied()) {
            if (log.isDebugEnabled()) {
                log.debug("proxy not applied " + StringUtil.toSafeString((Object)this.targetClassName));
            }
            if (this.targetClass != null) {
                return this.targetClass;
            }
            if (this.targetClassName != null) {
                try {
                    return ClassLoaderUtil.loadClass((String)this.targetClassName);
                }
                catch (ClassNotFoundException cnfex) {
                    throw new ProxettaException(cnfex);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("proxy created " + StringUtil.toSafeString((Object)this.targetClassName));
        }
        try {
            ClassLoader classLoader = this.proxetta.getClassLoader();
            if (classLoader == null) {
                if (this.targetClass != null) {
                    classLoader = this.targetClass.getClassLoader();
                }
                if (classLoader == null) {
                    classLoader = ClassLoaderUtil.getDefaultClassLoader();
                }
            }
            byte[] bytes = this.toByteArray();
            this.dumpClass(bytes);
            return ClassLoaderUtil.defineClass((String)this.getProxyClassName(), (byte[])bytes, (ClassLoader)classLoader);
        }
        catch (Exception ex) {
            throw new ProxettaException("Class definition failed.", ex);
        }
    }

    public Object newInstance() {
        Class type = this.define();
        try {
            return type.newInstance();
        }
        catch (Exception ex) {
            throw new ProxettaException("Unable to create new instance of Proxetta class.", ex);
        }
    }

    protected void dumpClass(byte[] bytes) {
        String fileName;
        String debugFolder = this.proxetta.getDebugFolder();
        if (debugFolder == null) {
            return;
        }
        File folder = new File(debugFolder);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if ((fileName = this.proxyClassName) == null) {
            fileName = "proxetta-" + System.currentTimeMillis();
        }
        fileName = fileName + ".class";
        File file = new File(folder, fileName);
        try {
            FileUtil.writeBytes((File)file, (byte[])bytes);
        }
        catch (IOException ioex) {
            log.warn("Error dumping class", ioex);
        }
    }

    protected void checkAccepted() {
        if (this.destClassWriter == null) {
            throw new ProxettaException("Target not accepted yet!");
        }
    }

    protected byte[] toByteArray() {
        this.checkAccepted();
        return this.destClassWriter.toByteArray();
    }

    public boolean isProxyApplied() {
        this.checkAccepted();
        return this.proxyApplied;
    }

    public String getProxyClassName() {
        this.checkAccepted();
        return this.proxyClassName;
    }
}

