/*
 * Decompiled with CFR 0.152.
 */
package jodd.vtor;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jodd.bean.BeanUtil;
import jodd.util.StringUtil;
import jodd.vtor.Check;
import jodd.vtor.ValidationConstraint;
import jodd.vtor.ValidationConstraintContext;
import jodd.vtor.ValidationContext;
import jodd.vtor.Violation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vtor {
    public static final String DEFAULT_PROFILE = "default";
    public static final String ALL_PROFILES = "*";
    protected List<Violation> violations;
    protected int severity;
    protected HashSet<String> enabledProfiles;
    protected boolean validateAllProfilesByDefault;

    public void addViolation(Violation v) {
        if (v == null) {
            return;
        }
        if (this.violations == null) {
            this.violations = new LinkedList<Violation>();
        }
        this.violations.add(v);
    }

    public void resetViolations() {
        this.violations = null;
    }

    public void validate(Object target) {
        this.validate(ValidationContext.resolveFor(target.getClass()), target);
    }

    public void validate(ValidationContext vctx, Object target) {
        this.validate(vctx, target, null);
    }

    public void validate(ValidationContext ctx, Object target, String targetName) {
        for (Map.Entry<String, List<Check>> entry : ctx.map.entrySet()) {
            String name = entry.getKey();
            Object value = BeanUtil.getDeclaredPropertySilently((Object)target, (String)name);
            String valueName = targetName != null ? targetName + '.' + name : name;
            ValidationConstraintContext vcc = new ValidationConstraintContext(this, target, valueName);
            for (Check check : entry.getValue()) {
                ValidationConstraint constraint;
                String[] checkProfiles = check.getProfiles();
                if (!this.matchProfiles(checkProfiles) || check.getSeverity() < this.severity || (constraint = check.getConstraint()).isValid(vcc, value)) continue;
                this.addViolation(new Violation(valueName, target, value, check));
            }
        }
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public boolean isValidateAllProfilesByDefault() {
        return this.validateAllProfilesByDefault;
    }

    public void setValidateAllProfilesByDefault(boolean validateAllProfilesByDefault) {
        this.validateAllProfilesByDefault = validateAllProfilesByDefault;
    }

    public void useProfile(String profile) {
        if (profile == null) {
            return;
        }
        if (this.enabledProfiles == null) {
            this.enabledProfiles = new HashSet();
        }
        this.enabledProfiles.add(profile);
    }

    public void useProfiles(String ... enabledProfiles) {
        if (enabledProfiles == null) {
            return;
        }
        if (this.enabledProfiles == null) {
            this.enabledProfiles = new HashSet();
        }
        for (String profile : enabledProfiles) {
            this.enabledProfiles.add(profile);
        }
    }

    public void resetProfiles() {
        this.enabledProfiles = null;
    }

    protected boolean matchProfiles(String[] checkProfiles) {
        if (checkProfiles != null && checkProfiles.length == 1 && checkProfiles[0].equals(ALL_PROFILES)) {
            return true;
        }
        if (this.enabledProfiles == null || this.enabledProfiles.isEmpty()) {
            if (this.validateAllProfilesByDefault) {
                return true;
            }
            if (checkProfiles == null || checkProfiles.length == 0) {
                return true;
            }
            for (String profile : checkProfiles) {
                if (StringUtil.isEmpty((String)profile)) {
                    return true;
                }
                if (!profile.equals(DEFAULT_PROFILE)) continue;
                return true;
            }
            return false;
        }
        if (checkProfiles == null || checkProfiles.length == 0) {
            return this.enabledProfiles.contains(DEFAULT_PROFILE);
        }
        boolean result = false;
        for (String profile : checkProfiles) {
            boolean b = true;
            boolean must = false;
            if (StringUtil.isEmpty((String)profile)) {
                profile = DEFAULT_PROFILE;
            } else if (profile.charAt(0) == '-') {
                profile = profile.substring(1);
                b = false;
            } else if (profile.charAt(0) == '+') {
                profile = profile.substring(1);
                must = true;
            }
            if (this.enabledProfiles.contains(profile)) {
                if (!b) {
                    return false;
                }
                result = true;
                continue;
            }
            if (!must) continue;
            return false;
        }
        return result;
    }

    public List<Violation> getViolations() {
        return this.violations;
    }

    public boolean hasViolations() {
        return this.violations != null;
    }
}

