/* The following code was generated by JFlex 1.4.3 on 12/6/11 2:35 PM */

package jodd.lagarto;

import java.nio.CharBuffer;

/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 12/6/11 2:35 PM from the specification file
 * <tt>lexer.flex</tt>
 */
final class Lexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 4096;

  /** lexical states */
  public static final int SCRIPT = 8;
  public static final int YYINITIAL = 0;
  public static final int STYLE = 10;
  public static final int ATTR = 4;
  public static final int XML_DECLARATION = 12;
  public static final int XMP = 6;
  public static final int TAG = 2;
  public static final int DOCTYPE = 14;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7, 7
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\10\0\2\23\1\23\1\0\2\23\22\0\1\23\1\2\1\34\4\0"+
    "\1\31\5\0\1\3\1\0\1\32\14\0\1\1\1\33\1\5\1\22"+
    "\1\0\1\15\1\0\1\10\1\6\1\14\1\20\2\0\1\17\2\0"+
    "\1\30\1\25\1\21\1\7\1\13\1\0\1\27\1\26\1\11\3\0"+
    "\1\24\1\12\1\0\1\4\1\0\1\16\3\0\1\15\1\0\1\10"+
    "\1\6\1\14\1\20\2\0\1\17\2\0\1\30\1\25\1\21\1\7"+
    "\1\13\1\0\1\27\1\26\1\11\3\0\1\24\1\12\uff86\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\6\0\1\2\1\3\1\1\1\4\1\5"+
    "\2\1\1\6\1\7\1\10\1\6\1\10\1\11\1\12"+
    "\7\10\1\13\1\10\1\0\1\14\3\1\1\15\1\0"+
    "\1\16\13\0\1\6\3\0\1\17\2\1\10\0\2\1"+
    "\12\0\1\1\1\20\11\0\1\21\1\22\3\0\1\23"+
    "\2\0\1\24\2\0\1\23\5\0\1\25\2\0\1\26"+
    "\2\0\1\27";

  private static int [] zzUnpackAction() {
    int [] result = new int[112];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
	// position methods
	public int position() { return yychar; }
	public int length()   { return yylength(); }
	public int line()     { return -1; /*yyline;*/ }   	// for debugging
	public int column()   { return -1; /*yycolumn;*/ } 	// for debugging

	// state methods
	public void stateReset() 	{ yybegin(YYINITIAL); }
	public void stateTag()		{ yybegin(TAG); }
	public void stateAttr()		{ yybegin(ATTR); }
	public void stateXmp() 		{ yybegin(XMP); }
	public void stateScript()   { yybegin(SCRIPT); }
	public void stateStyle()    { yybegin(STYLE); }
	public void stateDoctype()  { yybegin(DOCTYPE); }

	// fast methods
	public final CharSequence xxtext() {
		return CharBuffer.wrap(zzBuffer, zzStartRead, zzMarkedPos - zzStartRead);
	}
	public final String yytext(int startIndex) {
		startIndex += zzStartRead;
		return new String(zzBuffer, startIndex, zzMarkedPos - startIndex);
	}
	public final String yytext(int startIndex, int endIndexOffset) {
		startIndex += zzStartRead;
		return new String(zzBuffer, startIndex, zzMarkedPos - endIndexOffset - startIndex);
	}

	// empty ctor
	Lexer() {}

	int nextTagState;
	public int getNextTagState() {
		return nextTagState;
	}

	boolean parseHtml = true;
	public void setParseHtml(boolean parseHtml) {
		this.parseHtml = parseHtml;
	}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  Lexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  Lexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 138) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Token nextToken() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;


    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          zzInput = zzCMapL[zzInput];

          boolean zzIsFinal = false;
          boolean zzNoLookAhead = false;

          zzForNext: { switch (zzState) {
            case 0:
              switch (zzInput) {
                case 1: zzIsFinal = true; zzState = 9; break zzForNext;
                default: zzIsFinal = true; zzState = 8; break zzForNext;
              }

            case 1:
              switch (zzInput) {
                case 5: 
                case 14: 
                case 18: 
                case 25: 
                case 26: 
                case 27: 
                case 28: zzIsFinal = true; zzNoLookAhead = true; zzState = 11; break zzForNext;
                case 19: zzIsFinal = true; zzState = 12; break zzForNext;
                case 20: zzIsFinal = true; zzState = 13; break zzForNext;
                case 22: zzIsFinal = true; zzState = 14; break zzForNext;
                default: zzIsFinal = true; zzState = 10; break zzForNext;
              }

            case 2:
              switch (zzInput) {
                case 19: zzIsFinal = true; zzState = 12; break zzForNext;
                case 5: zzIsFinal = true; zzNoLookAhead = true; zzState = 16; break zzForNext;
                case 14: zzIsFinal = true; zzNoLookAhead = true; zzState = 17; break zzForNext;
                case 18: zzIsFinal = true; zzState = 18; break zzForNext;
                case 25: zzIsFinal = true; zzState = 19; break zzForNext;
                case 26: zzIsFinal = true; zzNoLookAhead = true; zzState = 20; break zzForNext;
                case 27: zzIsFinal = true; zzNoLookAhead = true; zzState = 21; break zzForNext;
                case 28: zzIsFinal = true; zzState = 22; break zzForNext;
                default: zzIsFinal = true; zzState = 15; break zzForNext;
              }

            case 3:
              switch (zzInput) {
                case 1: zzIsFinal = true; zzState = 24; break zzForNext;
                default: zzIsFinal = true; zzState = 23; break zzForNext;
              }

            case 4:
              switch (zzInput) {
                case 1: zzIsFinal = true; zzState = 26; break zzForNext;
                default: zzIsFinal = true; zzState = 25; break zzForNext;
              }

            case 5:
              switch (zzInput) {
                case 1: zzIsFinal = true; zzState = 28; break zzForNext;
                default: zzIsFinal = true; zzState = 27; break zzForNext;
              }

            case 6:
              switch (zzInput) {
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 17; break zzForNext;
              }

            case 7:
              switch (zzInput) {
                case 19: zzIsFinal = true; zzState = 12; break zzForNext;
                case 14: 
                case 25: 
                case 26: 
                case 27: zzIsFinal = true; zzNoLookAhead = true; zzState = 17; break zzForNext;
                case 5: zzIsFinal = true; zzNoLookAhead = true; zzState = 29; break zzForNext;
                case 28: zzIsFinal = true; zzState = 30; break zzForNext;
                default: zzIsFinal = true; zzState = 15; break zzForNext;
              }

            case 8:
              switch (zzInput) {
                case 1: break zzForAction;
                default: zzIsFinal = true; break zzForNext;
              }

            case 9:
              switch (zzInput) {
                case 2: zzState = 31; break zzForNext;
                case 18: zzIsFinal = true; zzNoLookAhead = true; zzState = 32; break zzForNext;
                default: break zzForAction;
              }

            case 10:
              switch (zzInput) {
                case 5: 
                case 14: 
                case 18: 
                case 19: 
                case 25: 
                case 26: 
                case 27: 
                case 28: break zzForAction;
                default: zzIsFinal = true; break zzForNext;
              }

            case 12:
              switch (zzInput) {
                case 19: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 13:
              switch (zzInput) {
                case 21: zzIsFinal = true; zzState = 33; break zzForNext;
                case 5: 
                case 14: 
                case 18: 
                case 19: 
                case 25: 
                case 26: 
                case 27: 
                case 28: break zzForAction;
                default: zzIsFinal = true; zzState = 10; break zzForNext;
              }

            case 14:
              switch (zzInput) {
                case 8: zzIsFinal = true; zzState = 34; break zzForNext;
                case 9: zzIsFinal = true; zzState = 35; break zzForNext;
                case 5: 
                case 14: 
                case 18: 
                case 19: 
                case 25: 
                case 26: 
                case 27: 
                case 28: break zzForAction;
                default: zzIsFinal = true; zzState = 10; break zzForNext;
              }

            case 15:
              switch (zzInput) {
                case 5: 
                case 14: 
                case 19: 
                case 26: 
                case 27: break zzForAction;
                default: zzIsFinal = true; break zzForNext;
              }

            case 18:
              switch (zzInput) {
                case 5: zzIsFinal = true; zzNoLookAhead = true; zzState = 36; break zzForNext;
                case 14: 
                case 19: 
                case 26: 
                case 27: break zzForAction;
                default: zzIsFinal = true; zzState = 15; break zzForNext;
              }

            case 19:
              switch (zzInput) {
                case 25: zzIsFinal = true; zzNoLookAhead = true; zzState = 38; break zzForNext;
                default: zzState = 37; break zzForNext;
              }

            case 22:
              switch (zzInput) {
                case 28: zzIsFinal = true; zzNoLookAhead = true; zzState = 38; break zzForNext;
                default: zzState = 39; break zzForNext;
              }

            case 23:
              switch (zzInput) {
                case 1: zzState = 41; break zzForNext;
                default: zzState = 40; break zzForNext;
              }

            case 24:
              switch (zzInput) {
                case 1: zzState = 41; break zzForNext;
                case 26: zzState = 42; break zzForNext;
                default: zzState = 40; break zzForNext;
              }

            case 25:
              switch (zzInput) {
                case 1: zzState = 44; break zzForNext;
                default: zzState = 43; break zzForNext;
              }

            case 26:
              switch (zzInput) {
                case 1: zzState = 44; break zzForNext;
                case 26: zzState = 45; break zzForNext;
                default: zzState = 43; break zzForNext;
              }

            case 27:
              switch (zzInput) {
                case 1: zzState = 47; break zzForNext;
                default: zzState = 46; break zzForNext;
              }

            case 28:
              switch (zzInput) {
                case 1: zzState = 47; break zzForNext;
                case 26: zzState = 48; break zzForNext;
                default: zzState = 46; break zzForNext;
              }

            case 30:
              switch (zzInput) {
                case 28: zzIsFinal = true; zzNoLookAhead = true; zzState = 50; break zzForNext;
                default: zzState = 49; break zzForNext;
              }

            case 31:
              switch (zzInput) {
                case 3: zzState = 51; break zzForNext;
                case 4: zzState = 52; break zzForNext;
                case 6: zzState = 53; break zzForNext;
                default: break zzForAction;
              }

            case 33:
              switch (zzInput) {
                case 11: zzIsFinal = true; zzState = 54; break zzForNext;
                case 5: 
                case 14: 
                case 18: 
                case 19: 
                case 25: 
                case 26: 
                case 27: 
                case 28: break zzForAction;
                default: zzIsFinal = true; zzState = 10; break zzForNext;
              }

            case 34:
              switch (zzInput) {
                case 23: zzIsFinal = true; zzState = 55; break zzForNext;
                case 5: 
                case 14: 
                case 18: 
                case 19: 
                case 25: 
                case 26: 
                case 27: 
                case 28: break zzForAction;
                default: zzIsFinal = true; zzState = 10; break zzForNext;
              }

            case 35:
              switch (zzInput) {
                case 10: zzIsFinal = true; zzState = 56; break zzForNext;
                case 5: 
                case 14: 
                case 18: 
                case 19: 
                case 25: 
                case 26: 
                case 27: 
                case 28: break zzForAction;
                default: zzIsFinal = true; zzState = 10; break zzForNext;
              }

            case 37:
              switch (zzInput) {
                case 25: zzIsFinal = true; zzNoLookAhead = true; zzState = 38; break zzForNext;
                default: break zzForNext;
              }

            case 39:
              switch (zzInput) {
                case 28: zzIsFinal = true; zzNoLookAhead = true; zzState = 38; break zzForNext;
                default: break zzForNext;
              }

            case 40:
              switch (zzInput) {
                case 1: zzState = 41; break zzForNext;
                default: break zzForNext;
              }

            case 41:
              switch (zzInput) {
                case 1: break zzForNext;
                case 26: zzState = 42; break zzForNext;
                default: zzState = 40; break zzForNext;
              }

            case 42:
              switch (zzInput) {
                case 1: zzState = 41; break zzForNext;
                case 20: zzState = 57; break zzForNext;
                default: zzState = 40; break zzForNext;
              }

            case 43:
              switch (zzInput) {
                case 1: zzState = 44; break zzForNext;
                default: break zzForNext;
              }

            case 44:
              switch (zzInput) {
                case 1: break zzForNext;
                case 26: zzState = 45; break zzForNext;
                default: zzState = 43; break zzForNext;
              }

            case 45:
              switch (zzInput) {
                case 1: zzState = 44; break zzForNext;
                case 22: zzState = 58; break zzForNext;
                default: zzState = 43; break zzForNext;
              }

            case 46:
              switch (zzInput) {
                case 1: zzState = 47; break zzForNext;
                default: break zzForNext;
              }

            case 47:
              switch (zzInput) {
                case 1: break zzForNext;
                case 26: zzState = 48; break zzForNext;
                default: zzState = 46; break zzForNext;
              }

            case 48:
              switch (zzInput) {
                case 1: zzState = 47; break zzForNext;
                case 22: zzState = 59; break zzForNext;
                default: zzState = 46; break zzForNext;
              }

            case 49:
              switch (zzInput) {
                case 28: zzIsFinal = true; zzNoLookAhead = true; zzState = 50; break zzForNext;
                default: break zzForNext;
              }

            case 51:
              switch (zzInput) {
                case 3: zzState = 60; break zzForNext;
                default: break zzForAction;
              }

            case 52:
              switch (zzInput) {
                case 8: zzState = 61; break zzForNext;
                case 12: zzState = 62; break zzForNext;
                case 15: zzState = 63; break zzForNext;
                default: break zzForAction;
              }

            case 53:
              switch (zzInput) {
                case 7: zzState = 64; break zzForNext;
                default: break zzForAction;
              }

            case 54:
              switch (zzInput) {
                case 5: 
                case 14: 
                case 18: 
                case 19: 
                case 25: 
                case 26: 
                case 27: 
                case 28: break zzForAction;
                default: zzIsFinal = true; zzState = 10; break zzForNext;
              }

            case 55:
              switch (zzInput) {
                case 15: zzIsFinal = true; zzState = 65; break zzForNext;
                case 5: 
                case 14: 
                case 18: 
                case 19: 
                case 25: 
                case 26: 
                case 27: 
                case 28: break zzForAction;
                default: zzIsFinal = true; zzState = 10; break zzForNext;
              }

            case 56:
              switch (zzInput) {
                case 24: zzIsFinal = true; zzState = 66; break zzForNext;
                case 5: 
                case 14: 
                case 18: 
                case 19: 
                case 25: 
                case 26: 
                case 27: 
                case 28: break zzForAction;
                default: zzIsFinal = true; zzState = 10; break zzForNext;
              }

            case 57:
              switch (zzInput) {
                case 1: zzState = 41; break zzForNext;
                case 21: zzState = 67; break zzForNext;
                default: zzState = 40; break zzForNext;
              }

            case 58:
              switch (zzInput) {
                case 1: zzState = 44; break zzForNext;
                case 8: zzState = 68; break zzForNext;
                default: zzState = 43; break zzForNext;
              }

            case 59:
              switch (zzInput) {
                case 1: zzState = 47; break zzForNext;
                case 9: zzState = 69; break zzForNext;
                default: zzState = 46; break zzForNext;
              }

            case 60:
              switch (zzInput) {
                case 3: zzState = 71; break zzForNext;
                case 4: zzState = 72; break zzForNext;
                default: zzState = 70; break zzForNext;
              }

            case 61:
              switch (zzInput) {
                case 6: zzState = 73; break zzForNext;
                default: break zzForAction;
              }

            case 62:
              switch (zzInput) {
                case 17: zzState = 74; break zzForNext;
                default: break zzForAction;
              }

            case 63:
              switch (zzInput) {
                case 16: zzState = 75; break zzForNext;
                default: break zzForAction;
              }

            case 64:
              switch (zzInput) {
                case 8: zzState = 76; break zzForNext;
                default: break zzForAction;
              }

            case 65:
              switch (zzInput) {
                case 11: zzIsFinal = true; zzState = 77; break zzForNext;
                case 5: 
                case 14: 
                case 18: 
                case 19: 
                case 25: 
                case 26: 
                case 27: 
                case 28: break zzForAction;
                default: zzIsFinal = true; zzState = 10; break zzForNext;
              }

            case 66:
              switch (zzInput) {
                case 12: zzIsFinal = true; zzState = 78; break zzForNext;
                case 5: 
                case 14: 
                case 18: 
                case 19: 
                case 25: 
                case 26: 
                case 27: 
                case 28: break zzForAction;
                default: zzIsFinal = true; zzState = 10; break zzForNext;
              }

            case 67:
              switch (zzInput) {
                case 1: zzState = 41; break zzForNext;
                case 11: zzState = 79; break zzForNext;
                default: zzState = 40; break zzForNext;
              }

            case 68:
              switch (zzInput) {
                case 1: zzState = 44; break zzForNext;
                case 23: zzState = 80; break zzForNext;
                default: zzState = 43; break zzForNext;
              }

            case 69:
              switch (zzInput) {
                case 1: zzState = 47; break zzForNext;
                case 10: zzState = 81; break zzForNext;
                default: zzState = 46; break zzForNext;
              }

            case 70:
              switch (zzInput) {
                case 3: zzState = 82; break zzForNext;
                default: break zzForNext;
              }

            case 71:
              switch (zzInput) {
                case 3: zzState = 83; break zzForNext;
                default: zzState = 70; break zzForNext;
              }

            case 72:
              switch (zzInput) {
                case 15: zzState = 63; break zzForNext;
                default: break zzForAction;
              }

            case 73:
              switch (zzInput) {
                case 13: zzState = 84; break zzForNext;
                default: break zzForAction;
              }

            case 74:
              switch (zzInput) {
                case 6: zzState = 85; break zzForNext;
                default: break zzForAction;
              }

            case 75:
              switch (zzInput) {
                case 14: zzState = 86; break zzForNext;
                default: break zzForNext;
              }

            case 76:
              switch (zzInput) {
                case 9: zzState = 87; break zzForNext;
                default: break zzForAction;
              }

            case 77:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzState = 88; break zzForNext;
                case 5: 
                case 14: 
                case 18: 
                case 19: 
                case 25: 
                case 26: 
                case 27: 
                case 28: break zzForAction;
                default: zzIsFinal = true; zzState = 10; break zzForNext;
              }

            case 78:
              switch (zzInput) {
                case 5: 
                case 14: 
                case 18: 
                case 19: 
                case 25: 
                case 26: 
                case 27: 
                case 28: break zzForAction;
                default: zzIsFinal = true; zzState = 10; break zzForNext;
              }

            case 79:
              switch (zzInput) {
                case 5: zzIsFinal = true; zzNoLookAhead = true; zzState = 89; break zzForNext;
                default: break zzForNext;
              }

            case 80:
              switch (zzInput) {
                case 1: zzState = 44; break zzForNext;
                case 15: zzState = 90; break zzForNext;
                default: zzState = 43; break zzForNext;
              }

            case 81:
              switch (zzInput) {
                case 1: zzState = 47; break zzForNext;
                case 24: zzState = 91; break zzForNext;
                default: zzState = 46; break zzForNext;
              }

            case 82:
              switch (zzInput) {
                case 3: zzState = 92; break zzForNext;
                default: zzState = 70; break zzForNext;
              }

            case 83:
              switch (zzInput) {
                case 3: zzState = 92; break zzForNext;
                case 5: zzIsFinal = true; zzState = 93; break zzForNext;
                default: zzState = 70; break zzForNext;
              }

            case 84:
              switch (zzInput) {
                case 9: zzState = 94; break zzForNext;
                default: break zzForAction;
              }

            case 85:
              switch (zzInput) {
                case 15: zzState = 95; break zzForNext;
                default: break zzForAction;
              }

            case 86:
              switch (zzInput) {
                case 14: break zzForNext;
                case 5: zzIsFinal = true; zzNoLookAhead = true; zzState = 96; break zzForNext;
                default: zzState = 75; break zzForNext;
              }

            case 87:
              switch (zzInput) {
                case 10: zzState = 97; break zzForNext;
                default: break zzForAction;
              }

            case 88:
              switch (zzInput) {
                case 5: 
                case 14: 
                case 18: 
                case 19: 
                case 25: 
                case 26: 
                case 27: 
                case 28: break zzForAction;
                default: zzIsFinal = true; zzState = 10; break zzForNext;
              }

            case 90:
              switch (zzInput) {
                case 1: zzState = 44; break zzForNext;
                case 11: zzState = 98; break zzForNext;
                default: zzState = 43; break zzForNext;
              }

            case 91:
              switch (zzInput) {
                case 1: zzState = 47; break zzForNext;
                case 12: zzState = 79; break zzForNext;
                default: zzState = 46; break zzForNext;
              }

            case 92:
              switch (zzInput) {
                case 3: break zzForNext;
                case 5: zzIsFinal = true; zzNoLookAhead = true; zzState = 99; break zzForNext;
                default: zzState = 70; break zzForNext;
              }

            case 93:
              switch (zzInput) {
                case 3: zzState = 82; break zzForNext;
                default: zzState = 70; break zzForNext;
              }

            case 94:
              switch (zzInput) {
                case 13: zzState = 100; break zzForNext;
                default: break zzForAction;
              }

            case 95:
              switch (zzInput) {
                case 16: zzState = 101; break zzForNext;
                default: break zzForAction;
              }

            case 97:
              switch (zzInput) {
                case 11: zzState = 102; break zzForNext;
                default: break zzForAction;
              }

            case 98:
              switch (zzInput) {
                case 1: zzState = 44; break zzForNext;
                case 9: zzState = 79; break zzForNext;
                default: zzState = 43; break zzForNext;
              }

            case 100:
              switch (zzInput) {
                case 4: zzState = 103; break zzForNext;
                default: break zzForAction;
              }

            case 101:
              switch (zzInput) {
                case 14: zzState = 104; break zzForNext;
                default: break zzForAction;
              }

            case 102:
              switch (zzInput) {
                case 12: zzIsFinal = true; zzNoLookAhead = true; zzState = 105; break zzForNext;
                default: break zzForAction;
              }

            case 103:
              switch (zzInput) {
                case 14: zzState = 106; break zzForNext;
                default: break zzForNext;
              }

            case 104:
              switch (zzInput) {
                case 3: zzState = 107; break zzForNext;
                case 5: zzIsFinal = true; zzNoLookAhead = true; zzState = 108; break zzForNext;
                default: break zzForAction;
              }

            case 106:
              switch (zzInput) {
                case 14: zzState = 109; break zzForNext;
                default: zzState = 103; break zzForNext;
              }

            case 107:
              switch (zzInput) {
                case 3: zzState = 110; break zzForNext;
                default: break zzForAction;
              }

            case 109:
              switch (zzInput) {
                case 14: break zzForNext;
                case 5: zzIsFinal = true; zzNoLookAhead = true; zzState = 111; break zzForNext;
                default: zzState = 103; break zzForNext;
              }

            case 110:
              switch (zzInput) {
                case 5: zzIsFinal = true; zzNoLookAhead = true; zzState = 108; break zzForNext;
                default: break zzForAction;
              }

            default:
              // if this is ever reached, there is a serious bug in JFlex
              zzScanError(ZZ_UNKNOWN_ERROR);
              break;
          } }

          if ( zzIsFinal ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( zzNoLookAhead ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 7: 
          { yybegin(nextTagState); return Token.GT;
          }
        case 24: break;
        case 23: 
          { return Token.CDATA;
          }
        case 25: break;
        case 13: 
          { stateReset(); return Token.XML_GT;
          }
        case 26: break;
        case 4: 
          { yypushback(1); stateAttr(); return Token.WHITESPACE;
          }
        case 27: break;
        case 16: 
          { if (parseHtml) nextTagState = STYLE; stateAttr(); return Token.WORD;
          }
        case 28: break;
        case 14: 
          { return Token.QUOTE;
          }
        case 29: break;
        case 6: 
          { return Token.WORD;
          }
        case 30: break;
        case 9: 
          { return Token.SLASH;
          }
        case 31: break;
        case 12: 
          { nextTagState = YYINITIAL; stateTag(); return Token.XML_LT;
          }
        case 32: break;
        case 18: 
          { stateReset(); return Token.TEXT;
          }
        case 33: break;
        case 10: 
          { return Token.EQUALS;
          }
        case 34: break;
        case 17: 
          { if (parseHtml) nextTagState = SCRIPT; stateAttr(); return Token.WORD;
          }
        case 35: break;
        case 15: 
          { if (parseHtml) nextTagState = XMP; stateAttr(); return Token.WORD;
          }
        case 36: break;
        case 5: 
          { return Token.WHITESPACE;
          }
        case 37: break;
        case 2: 
          { return Token.TEXT;
          }
        case 38: break;
        case 22: 
          { return Token.CONDITIONAL_COMMENT_END;
          }
        case 39: break;
        case 21: 
          { stateDoctype(); return Token.DOCTYPE;
          }
        case 40: break;
        case 3: 
          { nextTagState = YYINITIAL; stateTag(); return Token.LT;
          }
        case 41: break;
        case 11: 
          { stateReset(); return Token.GT;
          }
        case 42: break;
        case 8: 
          { throw new LagartoException("Illegal character ["+ yytext() + ']', yystate(), line(), column());
          }
        case 43: break;
        case 20: 
          { return Token.CONDITIONAL_COMMENT_START;
          }
        case 44: break;
        case 19: 
          { return Token.COMMENT;
          }
        case 45: break;
        case 1: 
          { stateAttr(); return Token.WORD;
          }
        case 46: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              {
                return Token.EOF;
              }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
