/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.sqlgen.chunks;

import jodd.db.oom.ColumnAliasType;
import jodd.db.oom.DbEntityColumnDescriptor;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.sqlgen.DbSqlBuilderException;
import jodd.db.oom.sqlgen.TemplateData;
import jodd.db.oom.sqlgen.chunks.SqlChunk;

public class ColumnsSelectChunk
extends SqlChunk {
    private static final String AS = " as ";
    protected final String tableRef;
    protected final String columnRef;
    protected final int includeColumns;
    protected final String hint;

    protected ColumnsSelectChunk(String tableRef, String columnRef, int includeColumns, String hint) {
        super(1);
        this.tableRef = tableRef;
        this.columnRef = columnRef;
        this.includeColumns = includeColumns;
        this.hint = hint;
    }

    public ColumnsSelectChunk(String tableRef, String columnRef) {
        this(tableRef, columnRef, 0, null);
    }

    public ColumnsSelectChunk(String tableRef, boolean includeAll) {
        this(tableRef, null, includeAll ? 3 : 2, null);
    }

    public ColumnsSelectChunk(String reference) {
        super(1);
        reference = reference.trim();
        int dotNdx = reference.lastIndexOf(46);
        if (dotNdx == -1) {
            this.tableRef = reference;
            this.columnRef = null;
            this.includeColumns = 3;
            this.hint = null;
        } else {
            String tref = reference.substring(0, dotNdx);
            reference = reference.substring(dotNdx + 1);
            dotNdx = tref.lastIndexOf(46);
            if (dotNdx == -1) {
                this.tableRef = tref;
                this.hint = null;
            } else {
                this.tableRef = tref.substring(dotNdx + 1);
                this.hint = tref;
            }
            if (reference.equals("*")) {
                this.columnRef = null;
                this.includeColumns = 3;
            } else if (reference.equals("+")) {
                this.columnRef = null;
                this.includeColumns = 2;
            } else {
                this.columnRef = reference;
                this.includeColumns = 0;
            }
        }
    }

    public void init(TemplateData templateData) {
        super.init(templateData);
        if (this.hint != null) {
            templateData.incrementHintsCount();
        }
    }

    public void process(StringBuilder out) {
        if (this.templateData.hasHints()) {
            this.templateData.registerHint(this.hint == null ? this.tableRef : this.hint);
        }
        this.separateByCommaOrSpace(out);
        boolean useTableReference = true;
        DbEntityDescriptor ded = this.lookupTableRef(this.tableRef, false);
        if (ded == null) {
            useTableReference = false;
            ded = this.lookupName(this.tableRef);
        }
        if (this.columnRef == null) {
            DbEntityColumnDescriptor[] decList = ded.getColumnDescriptors();
            int count = 0;
            for (DbEntityColumnDescriptor dec : decList) {
                if (this.includeColumns == 2 && !dec.isId()) continue;
                if (count > 0) {
                    out.append(',').append(' ');
                }
                this.templateData.lastColumnDec = dec;
                if (useTableReference) {
                    this.appendColumnName(out, ded, dec.getColumnName());
                } else {
                    this.appendAlias(out, ded, dec.getColumnName());
                }
                ++count;
            }
        } else {
            String columnName;
            DbEntityColumnDescriptor dec;
            this.templateData.lastColumnDec = dec = ded.findByPropertyName(this.columnRef);
            String string = columnName = dec == null ? null : dec.getColumnName();
            if (columnName == null) {
                throw new DbSqlBuilderException("Unable to resolve column reference: '" + this.tableRef + '.' + this.columnRef + "'.");
            }
            if (useTableReference) {
                this.appendColumnName(out, ded, columnName);
            } else {
                this.appendAlias(out, ded, columnName);
            }
        }
    }

    protected void appendAlias(StringBuilder query, DbEntityDescriptor ded, String column) {
        String tableName = ded.getTableName();
        ColumnAliasType columnAliasType = this.templateData.getColumnAliasType();
        String columnAliasSeparator = this.templateData.getDbOomManager().getColumnAliasSeparator();
        if (columnAliasType == null || columnAliasType == ColumnAliasType.TABLE_REFERENCE) {
            this.templateData.registerColumnDataForTableRef(this.tableRef, tableName);
            query.append(this.tableRef).append(columnAliasSeparator).append(column);
        } else if (columnAliasType == ColumnAliasType.COLUMN_CODE) {
            String code = this.templateData.registerColumnDataForColumnCode(tableName, column);
            query.append(code);
        } else if (columnAliasType == ColumnAliasType.TABLE_NAME) {
            query.append(tableName).append(columnAliasSeparator).append(column);
        }
    }

    protected void appendColumnName(StringBuilder query, DbEntityDescriptor ded, String column) {
        query.append(this.resolveTable(this.tableRef, ded)).append('.').append(column);
        if (this.templateData.getColumnAliasType() != null) {
            String tableName = ded.getTableName();
            query.append(AS);
            switch (this.templateData.getColumnAliasType()) {
                case TABLE_NAME: {
                    query.append(tableName).append(this.templateData.getDbOomManager().getColumnAliasSeparator()).append(column);
                    break;
                }
                case TABLE_REFERENCE: {
                    this.templateData.registerColumnDataForTableRef(this.tableRef, tableName);
                    query.append(this.tableRef).append(this.templateData.getDbOomManager().getColumnAliasSeparator()).append(column);
                    break;
                }
                case COLUMN_CODE: {
                    String code = this.templateData.registerColumnDataForColumnCode(tableName, column);
                    query.append(code);
                }
            }
        }
    }

    public SqlChunk clone() {
        return new ColumnsSelectChunk(this.tableRef, this.columnRef, this.includeColumns, this.hint);
    }
}

