/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.csselly.selector;

import java.util.LinkedList;
import jodd.lagarto.csselly.selector.PseudoFunctionExpression;
import jodd.lagarto.dom.Node;
import jodd.typeconverter.Convert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PseudoFunction {
    public abstract boolean match(Node var1, String var2);

    public boolean match(LinkedList<Node> currentResults, Node node, int index, String expression) {
        return true;
    }

    public String getPseudoFunctionName() {
        String name = this.getClass().getSimpleName().toLowerCase();
        name = name.replace('_', '-');
        return name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LT
    extends PseudoFunction {
        @Override
        public boolean match(Node node, String expression) {
            return true;
        }

        @Override
        public boolean match(LinkedList<Node> currentResults, Node node, int index, String expression) {
            int value = Convert.toInteger((Object)expression);
            return index < value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GT
    extends PseudoFunction {
        @Override
        public boolean match(Node node, String expression) {
            return true;
        }

        @Override
        public boolean match(LinkedList<Node> currentResults, Node node, int index, String expression) {
            int value = Convert.toInteger((Object)expression);
            return index > value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EQ
    extends PseudoFunction {
        @Override
        public boolean match(Node node, String expression) {
            return true;
        }

        @Override
        public boolean match(LinkedList<Node> currentResults, Node node, int index, String expression) {
            int value = Convert.toInteger((Object)expression);
            if (value >= 0) {
                return index == value;
            }
            return index == currentResults.size() + value;
        }
    }

    public static class NTH_LAST_OF_TYPE
    extends PseudoFunction {
        public boolean match(Node node, String expression) {
            Node child = node.getParentNode().getLastChildElement(node.getNodeName());
            int value = child.getSiblingNameIndex() + 1 - node.getSiblingNameIndex();
            return new PseudoFunctionExpression(expression).match(value);
        }
    }

    public static class NTH_OF_TYPE
    extends PseudoFunction {
        public boolean match(Node node, String expression) {
            int value = node.getSiblingNameIndex() + 1;
            return new PseudoFunctionExpression(expression).match(value);
        }
    }

    public static class NTH_LAST_CHILD
    extends PseudoFunction {
        public boolean match(Node node, String expression) {
            int value = node.getParentNode().getChildElementsCount() - node.getSiblingElementIndex();
            return new PseudoFunctionExpression(expression).match(value);
        }
    }

    public static class NTH_CHILD
    extends PseudoFunction {
        public boolean match(Node node, String expression) {
            int value = node.getSiblingElementIndex() + 1;
            return new PseudoFunctionExpression(expression).match(value);
        }
    }
}

