/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom.jerry;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jodd.lagarto.dom.Document;
import jodd.lagarto.dom.LagartoDOMBuilder;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.NodeSelector;
import jodd.lagarto.dom.Text;
import jodd.lagarto.dom.jerry.JerryFunction;
import jodd.lagarto.dom.jerry.JerryNodeFunction;
import jodd.util.ArraysUtil;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jerry {
    protected final Jerry parent;
    protected final Node[] nodes;

    public static Jerry jerry(CharSequence content) {
        Document doc = new LagartoDOMBuilder().parse(content);
        return new Jerry(null, doc);
    }

    public static Jerry jerry(CharBuffer content) {
        Document doc = new LagartoDOMBuilder().parse(content);
        return new Jerry(null, doc);
    }

    protected Jerry(Jerry parent, Node ... nodes) {
        this.parent = parent;
        this.nodes = nodes;
    }

    protected Jerry(Jerry parent, Node[] nodes1, Node[] nodes2) {
        this.parent = parent;
        this.nodes = (Node[])ArraysUtil.merge((Object[][])new Node[][]{nodes1, nodes2});
    }

    protected Jerry(Jerry parent, List<Node> nodeList) {
        this(parent, nodeList.toArray(new Node[nodeList.size()]));
    }

    public int length() {
        return this.nodes.length;
    }

    public int size() {
        return this.nodes.length;
    }

    public Node get(int index) {
        return this.nodes[index];
    }

    public Node[] get() {
        return this.nodes;
    }

    public int index(Node element) {
        int index = 0;
        for (Node node : this.nodes) {
            if (node == element) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public Jerry children() {
        NodeList result = new NodeList(this.nodes.length);
        for (Node node : this.nodes) {
            Node[] children;
            for (Node child : children = node.getChildElements()) {
                result.add(child);
            }
        }
        return new Jerry(this, result);
    }

    public Jerry parent() {
        NodeList result = new NodeList(this.nodes.length);
        for (Node node : this.nodes) {
            result.add(node.getParentNode());
        }
        return new Jerry(this, result);
    }

    public Jerry siblings() {
        NodeList result = new NodeList(this.nodes.length);
        for (Node node : this.nodes) {
            Node[] allElements;
            for (Node sibling : allElements = node.getParentNode().getChildElements()) {
                if (sibling == node) continue;
                result.add(sibling);
            }
        }
        return new Jerry(this, result);
    }

    public Jerry next() {
        NodeList result = new NodeList(this.nodes.length);
        for (Node node : this.nodes) {
            result.add(node.getNextSiblingElement());
        }
        return new Jerry(this, result);
    }

    public Jerry prev() {
        NodeList result = new NodeList(this.nodes.length);
        for (Node node : this.nodes) {
            result.add(node.getPreviousSiblingElement());
        }
        return new Jerry(this, result);
    }

    public Jerry find(String cssSelector) {
        NodeList result = new NodeList();
        for (Node node : this.nodes) {
            NodeSelector nodeSelector = this.createNodeSelector(node);
            LinkedList<Node> filteredNodes = nodeSelector.select(cssSelector);
            result.addAll(filteredNodes);
        }
        return new Jerry(this, result);
    }

    public Jerry $(String cssSelector) {
        return this.find(cssSelector);
    }

    protected NodeSelector createNodeSelector(Node node) {
        return new NodeSelector(node);
    }

    public Jerry each(JerryFunction function) {
        for (int i = 0; i < this.nodes.length; ++i) {
            Node node = this.nodes[i];
            Jerry $this = new Jerry(this, node);
            if (!function.onNode($this, i)) break;
        }
        return this;
    }

    public Jerry each(JerryNodeFunction function) {
        Node node;
        for (int i = 0; i < this.nodes.length && function.onNode(node = this.nodes[i], i); ++i) {
        }
        return this;
    }

    public Jerry add(String selector) {
        return new Jerry(this, this.nodes, this.root().find((String)selector).nodes);
    }

    public Jerry end() {
        return this.parent;
    }

    public Jerry not(String cssSelector) {
        Object[] notNodes = this.root().find((String)cssSelector).nodes;
        NodeList result = new NodeList(this.nodes.length);
        for (Node node : this.nodes) {
            if (ArraysUtil.contains((Object[])notNodes, (Object)node)) continue;
            result.add(node);
        }
        return new Jerry(this, result);
    }

    public Jerry root() {
        Jerry jerry = this.parent;
        if (jerry == null) {
            return this;
        }
        while (jerry.parent != null) {
            jerry = jerry.parent;
        }
        return jerry;
    }

    public Jerry first() {
        NodeList result = new NodeList(this.nodes.length);
        for (Node node : this.nodes) {
            if (node.getSiblingElementIndex() != 0) continue;
            result.add(node);
        }
        return new Jerry(this, result);
    }

    public Jerry last() {
        NodeList result = new NodeList(this.nodes.length);
        for (Node node : this.nodes) {
            int elementsLastIndex = node.getParentNode().getChildElementsCount() - 1;
            if (node.getSiblingElementIndex() != elementsLastIndex) continue;
            result.add(node);
        }
        return new Jerry(this, result);
    }

    public Jerry eq(int value) {
        NodeList result = new NodeList(1);
        int index = 0;
        int matchingIndex = value >= 0 ? value : this.nodes.length + value;
        for (Node node : this.nodes) {
            if (index == matchingIndex) {
                result.add(node);
                break;
            }
            ++index;
        }
        return new Jerry(this, result);
    }

    public Jerry gt(int value) {
        NodeList result = new NodeList(this.nodes.length);
        int index = 0;
        for (Node node : this.nodes) {
            if (index > value) {
                result.add(node);
            }
            ++index;
        }
        return new Jerry(this, result);
    }

    public Jerry lt(int value) {
        NodeList result = new NodeList(this.nodes.length);
        int index = 0;
        for (Node node : this.nodes) {
            if (index < value) {
                result.add(node);
            }
            ++index;
        }
        return new Jerry(this, result);
    }

    public String attr(String name) {
        return this.nodes[0].getAttribute(name);
    }

    public Jerry attr(String name, String value) {
        for (Node node : this.nodes) {
            node.setAttribute(name, value);
        }
        return this;
    }

    public Jerry removeAttr(String name) {
        for (Node node : this.nodes) {
            node.removeAttribute(name);
        }
        return this;
    }

    public String css(String propertyName) {
        propertyName = StringUtil.camelCaseToWords((String)propertyName, (char)'-');
        String styleAttrValue = this.nodes[0].getAttribute("style");
        if (styleAttrValue == null) {
            return null;
        }
        Map<String, String> styles = this.createPropertiesMap(styleAttrValue, ';', ':');
        return styles.get(propertyName);
    }

    public Jerry css(String propertyName, String value) {
        propertyName = StringUtil.camelCaseToWords((String)propertyName, (char)'-');
        for (Node node : this.nodes) {
            String styleAttrValue = node.getAttribute("style");
            Map<String, String> styles = this.createPropertiesMap(styleAttrValue, ';', ':');
            styles.put(propertyName, value);
            styleAttrValue = this.generateAttributeValue(styles, ';', ':');
            node.setAttribute("style", styleAttrValue);
        }
        return this;
    }

    public Jerry css(String ... css) {
        for (Node node : this.nodes) {
            String styleAttrValue = node.getAttribute("style");
            Map<String, String> styles = this.createPropertiesMap(styleAttrValue, ';', ':');
            for (int i = 0; i < css.length; i += 2) {
                String propertyName = css[i];
                propertyName = StringUtil.camelCaseToWords((String)propertyName, (char)'-');
                styles.put(propertyName, css[i + 1]);
            }
            styleAttrValue = this.generateAttributeValue(styles, ';', ':');
            node.setAttribute("style", styleAttrValue);
        }
        return this;
    }

    public Jerry addClass(String ... classNames) {
        for (Node node : this.nodes) {
            String attrClass = node.getAttribute("class");
            Set<String> classes = this.createPropertiesSet(attrClass, ' ');
            boolean wasChange = false;
            for (String className : classNames) {
                if (!classes.add(className = StringUtil.camelCaseToWords((String)className, (char)'-'))) continue;
                wasChange = true;
            }
            if (!wasChange) continue;
            String attrValue = this.generateAttributeValue(classes, ' ');
            node.setAttribute("class", attrValue);
        }
        return this;
    }

    public boolean hasClass(String ... classNames) {
        for (Node node : this.nodes) {
            String attrClass = node.getAttribute("class");
            Set<String> classes = this.createPropertiesSet(attrClass, ' ');
            for (String className : classNames) {
                if (!classes.contains(className = StringUtil.camelCaseToWords((String)className, (char)'-'))) continue;
                return true;
            }
        }
        return false;
    }

    public Jerry removeClass(String ... classNames) {
        for (Node node : this.nodes) {
            String attrClass = node.getAttribute("class");
            Set<String> classes = this.createPropertiesSet(attrClass, ' ');
            boolean wasChange = false;
            for (String className : classNames) {
                if (!classes.remove(className = StringUtil.camelCaseToWords((String)className, (char)'-'))) continue;
                wasChange = true;
            }
            if (!wasChange) continue;
            String attrValue = this.generateAttributeValue(classes, ' ');
            node.setAttribute("class", attrValue);
        }
        return this;
    }

    public Jerry toggleClass(String ... classNames) {
        for (Node node : this.nodes) {
            String attrClass = node.getAttribute("class");
            Set<String> classes = this.createPropertiesSet(attrClass, ' ');
            for (String className : classNames) {
                if (classes.contains(className = StringUtil.camelCaseToWords((String)className, (char)'-'))) {
                    classes.remove(className);
                    continue;
                }
                classes.add(className);
            }
            String attrValue = this.generateAttributeValue(classes, ' ');
            node.setAttribute("class", attrValue);
        }
        return this;
    }

    public String text() {
        StringBuilder sb = new StringBuilder();
        for (Node node : this.nodes) {
            sb.append(node.getTextContent());
        }
        return sb.toString();
    }

    public Jerry text(String text) {
        for (Node node : this.nodes) {
            node.removeAllChilds();
            Text textNode = new Text();
            textNode.setText(text);
            node.appendChild((Node)textNode);
        }
        return this;
    }

    public String html() {
        return this.nodes[0].getInnerHtml();
    }

    public Jerry html(String html) {
        Document doc = new LagartoDOMBuilder().parse(html);
        for (Node node : this.nodes) {
            node.removeAllChilds();
            Document workingDoc = doc.clone();
            node.appendChild(workingDoc.getChildNodes());
        }
        return this;
    }

    public Jerry append(String html) {
        Document doc = new LagartoDOMBuilder().parse(html);
        for (Node node : this.nodes) {
            Document workingDoc = doc.clone();
            node.appendChild((Node)workingDoc);
        }
        return this;
    }

    public Jerry before(String html) {
        Document doc = new LagartoDOMBuilder().parse(html);
        for (Node node : this.nodes) {
            Document workingDoc = doc.clone();
            node.insertBefore(workingDoc, node);
        }
        return this;
    }

    public Jerry remove() {
        for (Node node : this.nodes) {
            node.detachFromParent();
        }
        return this;
    }

    public Jerry detach() {
        for (Node node : this.nodes) {
            node.detachFromParent();
        }
        return this;
    }

    public Jerry empty() {
        for (Node node : this.nodes) {
            node.removeAllChilds();
        }
        return this;
    }

    public Jerry wrap(String html) {
        Document doc = new LagartoDOMBuilder().parse(html);
        for (Node node : this.nodes) {
            Document workingDoc = doc.clone();
            Node inmostNode = workingDoc;
            while (inmostNode.hasChildNodes()) {
                inmostNode = inmostNode.getFirstChild();
            }
            Node parent = node.getParentNode();
            int index = node.getSiblingIndex();
            inmostNode.appendChild(node);
            parent.insertChild(workingDoc.getFirstChild(), index);
        }
        return this;
    }

    protected Set<String> createPropertiesSet(String attrValue, char propertiesDelimiter) {
        if (attrValue == null) {
            return new LinkedHashSet<String>();
        }
        String[] properties = StringUtil.splitc((String)attrValue, (char)propertiesDelimiter);
        LinkedHashSet<String> set = new LinkedHashSet<String>(properties.length);
        for (String property : properties) {
            set.add(property);
        }
        return set;
    }

    protected String generateAttributeValue(Set<String> set, char propertiesDelimiter) {
        StringBuilder sb = new StringBuilder(set.size() * 16);
        boolean first = true;
        for (String entry : set) {
            if (!first) {
                sb.append(propertiesDelimiter);
            } else {
                first = false;
            }
            sb.append(entry);
        }
        return sb.toString();
    }

    protected Map<String, String> createPropertiesMap(String attrValue, char propertiesDelimiter, char valueDelimiter) {
        if (attrValue == null) {
            return new LinkedHashMap<String, String>();
        }
        String[] properties = StringUtil.splitc((String)attrValue, (char)propertiesDelimiter);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(properties.length);
        for (String property : properties) {
            int valueDelimiterIndex = property.indexOf(valueDelimiter);
            if (valueDelimiterIndex == -1) continue;
            String propertyName = property.substring(0, valueDelimiterIndex).trim();
            String propertyValue = property.substring(valueDelimiterIndex + 1).trim();
            map.put(propertyName, propertyValue);
        }
        return map;
    }

    protected String generateAttributeValue(Map<String, String> map, char propertiesDelimiter, char valueDelimiter) {
        StringBuilder sb = new StringBuilder(map.size() * 32);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(entry.getKey());
            sb.append(valueDelimiter);
            sb.append(entry.getValue());
            sb.append(propertiesDelimiter);
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeList
    extends ArrayList<Node> {
        private NodeList(int initialCapacity) {
            super(initialCapacity);
        }

        private NodeList() {
        }

        @Override
        public boolean add(Node o) {
            for (Node node : this) {
                if (node != o) continue;
                return false;
            }
            return super.add(o);
        }
    }
}

