/*
 * Decompiled with CFR 0.152.
 */
package jodd.julianday;

import java.math.BigDecimal;
import java.util.Objects;

public class DayValue {
    private final int day;
    private final double time;

    public int day() {
        return this.day;
    }

    public double time() {
        return this.time;
    }

    public DayValue(int day, double time) {
        this.day = day;
        this.time = time;
    }

    public double toDouble() {
        return (double)this.day + this.time;
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.day).add(new BigDecimal(this.time));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DayValue dayValue = (DayValue)o;
        return this.day == dayValue.day && StrictMath.abs(this.time - dayValue.time) < 1.0E-10;
    }

    public int hashCode() {
        return Objects.hash(this.day, this.time);
    }

    public String toString() {
        return "DayValue{day=" + this.day + ", time=" + this.time + '}';
    }
}

