/*
 * Decompiled with CFR 0.152.
 */
package jodd.julianday;

import java.util.Objects;
import jodd.julianday.JulianDayFunctions;

public class JulianDateTime {
    private final int year;
    private final int month;
    private final int day;
    private final int hour;
    private final int minute;
    private final int second;
    private final int millisecond;

    public int getYear() {
        return this.year;
    }

    public int getMonthValue() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getMillisecond() {
        return this.millisecond;
    }

    public JulianDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.millisecond = millisecond;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JulianDateTime that = (JulianDateTime)o;
        return this.year == that.year && this.month == that.month && this.day == that.day && this.hour == that.hour && this.minute == that.minute && this.second == that.second && this.millisecond == that.millisecond;
    }

    public int hashCode() {
        return Objects.hash(this.year, this.month, this.day, this.hour, this.minute, this.second, this.millisecond);
    }

    public String toString() {
        return this.year + "-" + JulianDateTime.pad0(this.month) + "-" + JulianDateTime.pad0(this.day) + "J" + JulianDateTime.pad0(this.hour) + ":" + JulianDateTime.pad0(this.minute) + ":" + JulianDateTime.pad0(this.second) + "." + JulianDateTime.pad00(this.millisecond);
    }

    public boolean isLeapYear() {
        return JulianDayFunctions.isLeapJulianYear(this.year);
    }

    private static String pad0(int value) {
        return value < 10 ? "0" + value : String.valueOf(value);
    }

    private static String pad00(int value) {
        return value < 10 ? "00" + value : (value < 100 ? "0" + value : String.valueOf(value));
    }
}

