/*
 * Decompiled with CFR 0.152.
 */
package jodd.julianday;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import jodd.julianday.DayValue;
import jodd.julianday.JulianDateTime;
import jodd.julianday.JulianDayFunctions;

public class JulianDay {
    public static final JulianDay REDUCED_JULIAN_DAY_0 = new JulianDay(2400000, 0.0);
    public static final JulianDay MODIFIED_JULIAN_DAY_0 = new JulianDay(2400000, 0.5);
    public static final JulianDay TRUNCATED_JULIAN_DAY_0 = new JulianDay(2440000, 0.5);
    private final DayValue value;

    public int day() {
        return this.value.day();
    }

    public double time() {
        return this.value.time();
    }

    public JulianDay(int day, double time) {
        int timeDays = (int)time;
        int daysCorrected = day + timeDays;
        double timeCorrected = time - (double)timeDays;
        this.value = timeCorrected < 0.0 ? new DayValue(daysCorrected - 1, timeCorrected + 1.0) : new DayValue(daysCorrected, timeCorrected);
    }

    public JulianDay add(JulianDay jd) {
        return new JulianDay(this.day() + jd.day(), this.time() + jd.time());
    }

    public JulianDay add(double days) {
        return new JulianDay(this.day() + (int)days, this.time() + (days - (double)((int)days)));
    }

    public JulianDay add(DayValue value) {
        return new JulianDay(this.day() + value.day(), this.time() + value.time());
    }

    public JulianDay subtract(JulianDay jd) {
        return new JulianDay(this.day() - jd.day(), this.time() - jd.time());
    }

    public JulianDay subtract(double days) {
        return new JulianDay(this.day() - (int)days, this.time() - (days - (double)((int)days)));
    }

    public JulianDay subtract(DayValue value) {
        return new JulianDay(this.day() - value.day(), this.time() - value.time());
    }

    public double toDouble() {
        return this.value.toDouble();
    }

    public BigDecimal toBigDecimal() {
        return this.value.toBigDecimal();
    }

    public JulianDateTime toJulianDate() {
        int[] d = JulianDayFunctions.jdToJulian(this);
        int[] t = JulianDayFunctions.jhms(this);
        return new JulianDateTime(d[0], d[1], d[2], t[0], t[1], t[2], t[3]);
    }

    public LocalDateTime toGregorianDate() {
        int[] d = JulianDayFunctions.jdToGregorian(this);
        int[] t = JulianDayFunctions.jhms(this);
        return LocalDateTime.of(d[0], d[1], d[2], t[0], t[1], t[2], t[3] * 1000000);
    }

    public long toUnixMilliseconds() {
        return JulianDayFunctions.toUnixMillis(this);
    }

    public String toString() {
        String s = Double.toString(this.time());
        int i = s.indexOf(46);
        return this.day() + s.substring(i);
    }

    public static JulianDay of(int day, double time) {
        return new JulianDay(day, time);
    }

    public static JulianDay of(double jd) {
        int integer = (int)jd;
        double fraction = jd - (double)integer;
        return new JulianDay(integer, fraction);
    }

    public static JulianDay of(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        int integer = (int)d;
        double fraction = bigDecimal.subtract(new BigDecimal(integer)).doubleValue();
        return new JulianDay(integer, fraction);
    }

    public static JulianDay ofJulianDate(JulianDateTime jdt) {
        double jd = JulianDayFunctions.julianToJd(jdt.getYear(), jdt.getMonthValue(), jdt.getDayOfMonth());
        double jt = JulianDayFunctions.hmsj(jdt.getHour(), jdt.getMinute(), jdt.getSecond(), jdt.getMillisecond());
        return JulianDayFunctions.julianDay(jd, jt);
    }

    public static JulianDay ofGregorianDate(LocalDateTime ldt) {
        double jd = JulianDayFunctions.gregorianToJd(ldt.getYear(), ldt.getMonthValue(), ldt.getDayOfMonth());
        double jt = JulianDayFunctions.hmsj(ldt.getHour(), ldt.getMinute(), ldt.getSecond(), ldt.getNano() / 1000000);
        return JulianDayFunctions.julianDay(jd, jt);
    }

    public static JulianDay ofGregorianDate(LocalDate ld) {
        double jd = JulianDayFunctions.gregorianToJd(ld.getYear(), ld.getMonthValue(), ld.getDayOfMonth());
        return JulianDayFunctions.julianDay(jd, 0.0);
    }

    public static JulianDay ofUnixMilliseconds(long milliseconds) {
        return JulianDay.of(JulianDayFunctions.fromUnixMillis(milliseconds));
    }

    public static JulianDay now() {
        return JulianDay.ofGregorianDate(LocalDateTime.now());
    }

    private DayValue value() {
        return this.value;
    }

    public DayValue valueAsReducedJulianDay() {
        return this.subtract(REDUCED_JULIAN_DAY_0).value();
    }

    public DayValue valueAsModifiedJulianDay() {
        return this.subtract(MODIFIED_JULIAN_DAY_0).value();
    }

    public DayValue valueAsTruncatedJulianDay() {
        return this.subtract(TRUNCATED_JULIAN_DAY_0).value();
    }

    public static JulianDay of(DayValue value) {
        return new JulianDay(value.day(), value.time());
    }

    public static JulianDay ofReducedJulianDay(DayValue value) {
        return REDUCED_JULIAN_DAY_0.add(value);
    }

    public static JulianDay ofModifiedJulianDay(DayValue value) {
        return MODIFIED_JULIAN_DAY_0.add(value);
    }

    public static JulianDay ofTruncatedJulianDay(DayValue value) {
        return TRUNCATED_JULIAN_DAY_0.add(value);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JulianDay stamp = (JulianDay)object;
        return this.value.equals(stamp.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    protected JulianDay clone() {
        return new JulianDay(this.day(), this.time());
    }
}

