/*
 * Decompiled with CFR 0.152.
 */
package jodd.julianday;

import jodd.julianday.JulianDay;

class JulianDayFunctions {
    static final double GREGORIAN_EPOCH = 1721425.5;
    static final double J1970 = 2440587.5;

    JulianDayFunctions() {
    }

    static int[] jdToJulian(JulianDay jd) {
        double s;
        double o;
        double r = jd.toDouble() + 0.5;
        double t = StrictMath.floor(r);
        double n = t + 1524.0;
        double u = StrictMath.floor((n - (o = StrictMath.floor(365.25 * (s = StrictMath.floor((n - 122.1) / 365.25))))) / 30.6001);
        double h = StrictMath.floor(u < 14.0 ? u - 1.0 : u - 13.0);
        double i = StrictMath.floor(h > 2.0 ? s - 4716.0 : s - 4715.0);
        double l = n - o - StrictMath.floor(30.6001 * u);
        return new int[]{(int)i, (int)h, (int)l};
    }

    static double julianToJd(int year, int month, int day) {
        if (month <= 2) {
            --year;
            month += 12;
        }
        return StrictMath.floor(365.25 * (double)(year + 4716)) + StrictMath.floor(30.6001 * (double)(month + 1)) + (double)day - 1524.5;
    }

    static int[] jdToGregorian(JulianDay jd) {
        double wjd = StrictMath.floor(jd.toDouble() - 0.5) + 0.5;
        double depoch = wjd - 1721425.5;
        double quadricent = StrictMath.floor(depoch / 146097.0);
        double dqc = JulianDayFunctions.mod(depoch, 146097.0);
        double cent = StrictMath.floor(dqc / 36524.0);
        double dcent = JulianDayFunctions.mod(dqc, 36524.0);
        double quad = StrictMath.floor(dcent / 1461.0);
        double dquad = JulianDayFunctions.mod(dcent, 1461.0);
        double yindex = StrictMath.floor(dquad / 365.0);
        int year = (int)(quadricent * 400.0 + cent * 100.0 + quad * 4.0 + yindex);
        if (cent != 4.0 && yindex != 4.0) {
            ++year;
        }
        double yearday = wjd - JulianDayFunctions.gregorianToJd(year, 1.0, 1.0);
        double leapadj = wjd < JulianDayFunctions.gregorianToJd(year, 3.0, 1.0) ? 0.0 : (double)(JulianDayFunctions.isLeapYear(year) ? 1 : 2);
        int month = (int)StrictMath.floor(((yearday + leapadj) * 12.0 + 373.0) / 367.0);
        double day = wjd - JulianDayFunctions.gregorianToJd(year, month, 1.0) + 1.0;
        return new int[]{year, month, (int)day};
    }

    static int[] jhms(JulianDay jd) {
        double civil = jd.time() + 0.5;
        double a = (civil - StrictMath.floor(civil)) * 86400.0 + 0.5;
        int h = (int)StrictMath.floor(a / 3600.0);
        int m = (int)StrictMath.floor(a / 60.0 % 60.0);
        double sm = a % 60.0;
        int s = (int)StrictMath.floor(sm);
        double millis = (sm - (double)s - 0.5) * 1000.0;
        int roundedMillis = (int)StrictMath.round(millis);
        if (roundedMillis < 0) {
            roundedMillis += 1000;
            --s;
        }
        if (s < 0) {
            s += 60;
            --m;
        }
        if (m < 0) {
            m += 60;
        }
        return new int[]{--h, m, s, roundedMillis};
    }

    static double hmsj(int h, int m, int s, int millis) {
        return (double)(h * 3600 + m * 60 + s) / 86400.0 + (double)millis / 8.64E7;
    }

    static double gregorianToJd(double year, double month, double day) {
        return 1721424.5 + 365.0 * (year - 1.0) + StrictMath.floor((year - 1.0) / 4.0) - StrictMath.floor((year - 1.0) / 100.0) + StrictMath.floor((year - 1.0) / 400.0) + StrictMath.floor((367.0 * month - 362.0) / 12.0 + (double)(month <= 2.0 ? 0 : (JulianDayFunctions.isLeapYear(year) ? -1 : -2)) + day);
    }

    static boolean isLeapYear(double year) {
        return year % 4.0 == 0.0 && (year % 100.0 != 0.0 || year % 400.0 == 0.0);
    }

    static boolean isLeapJulianYear(int julianYear) {
        return julianYear % 4 == 0;
    }

    static double mod(double a, double b) {
        return a - b * StrictMath.floor(a / b);
    }

    static JulianDay julianDay(double dayAtMidnight, double timeOfDay) {
        double jd = dayAtMidnight + timeOfDay;
        double dayFraction = dayAtMidnight - (double)((int)dayAtMidnight);
        double timeOffset = dayFraction + timeOfDay;
        double time = timeOffset >= 1.0 ? timeOffset - 1.0 : timeOffset;
        return new JulianDay((int)jd, time);
    }

    static long toUnixMillis(JulianDay jd) {
        long utime = (long)(jd.toDouble() - 2440587.5) * 86400000L;
        int[] t = JulianDayFunctions.jhms(jd);
        return utime + (long)t[0] * 3600000L + (long)t[1] * 60000L + (long)t[2] * 1000L + (long)t[3];
    }

    static double fromUnixMillis(long unixMillis) {
        return (double)unixMillis / 8.64E7 + 2440587.5;
    }
}

