/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.tracker.udp;

import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerAction;

public class Connection {
    private static final Duration LIFE_TIME = Duration.ofMinutes(1L);
    private static final long NO_CONNECTION_ID = 4497486125440L;
    private final long connnectionId;
    private final LocalDateTime creationTime;

    public Connection(Clock clock) {
        this(4497486125440L, clock);
    }

    public Connection(long connectionId, Clock clock) {
        this.connnectionId = connectionId;
        this.creationTime = LocalDateTime.now(clock);
    }

    public boolean isValidFor(TrackerAction action, Clock clock) {
        if (action == TrackerAction.CONNECT) {
            return this.connnectionId == 4497486125440L;
        }
        if (this.connnectionId == 4497486125440L) {
            return false;
        }
        return LocalDateTime.now(clock).minus(LIFE_TIME).isBefore(this.creationTime);
    }

    public String toString() {
        return "Connection [creationTime=" + this.creationTime + ", connnectionId=" + Long.toHexString(this.connnectionId).toUpperCase() + "]";
    }

    public long getId() {
        return this.connnectionId;
    }
}

