/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.tracker.udp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerAction;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerException;
import org.johnnei.javatorrent.internal.tracker.udp.Connection;
import org.johnnei.javatorrent.internal.tracker.udp.ConnectionRequest;
import org.johnnei.javatorrent.internal.tracker.udp.IUdpTrackerPayload;
import org.johnnei.javatorrent.internal.tracker.udp.TrackerRequest;
import org.johnnei.javatorrent.internal.tracker.udp.UdpSocketUtils;
import org.johnnei.javatorrent.network.InStream;
import org.johnnei.javatorrent.network.OutStream;
import org.johnnei.javatorrent.tracker.UdpTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpTrackerSocket
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(UdpTrackerSocket.class);
    private final Clock clock;
    private final TorrentClient torrentClient;
    private volatile boolean keepRunning = true;
    private final Object lock = new Object();
    private Map<Integer, SentRequest> pendingRespones;
    private Collection<UnsetRequest> unsentRequests;
    private UdpSocketUtils socketUtils;
    private DatagramSocket udpSocket;
    private final Lock taskLock = new ReentrantLock();
    private final Condition newWork;

    private UdpTrackerSocket(Builder builder) throws TrackerException {
        this.clock = builder.clock;
        this.newWork = this.taskLock.newCondition();
        this.torrentClient = builder.torrentClient;
        this.socketUtils = builder.socketUtils;
        try {
            this.udpSocket = new DatagramSocket(builder.socketPort);
            this.udpSocket.setSoTimeout((int)Duration.of(5L, ChronoUnit.SECONDS).toMillis());
        }
        catch (SocketException e) {
            throw new TrackerException("Failed to create UDP Socket", (Throwable)e);
        }
        this.pendingRespones = new HashMap<Integer, SentRequest>();
        this.unsentRequests = new LinkedList<UnsetRequest>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitRequest(UdpTracker tracker, IUdpTrackerPayload request) {
        Object object = this.lock;
        synchronized (object) {
            this.unsentRequests.add(new UnsetRequest(tracker, request));
        }
        this.taskLock.lock();
        try {
            this.newWork.signalAll();
        }
        finally {
            this.taskLock.unlock();
        }
    }

    @Override
    public void run() {
        try {
            while (this.keepRunning) {
                this.processWork();
                this.waitForWork();
            }
        }
        finally {
            this.udpSocket.close();
        }
    }

    private void waitForWork() {
        if (!this.pendingRespones.isEmpty()) {
            return;
        }
        if (!this.unsentRequests.isEmpty()) {
            return;
        }
        if (!this.keepRunning) {
            return;
        }
        this.taskLock.lock();
        try {
            this.newWork.awaitUninterruptibly();
        }
        finally {
            this.taskLock.unlock();
        }
    }

    private void processWork() {
        Collection<SentRequest> timedoutRequests;
        if (!this.unsentRequests.isEmpty()) {
            this.sendRequests();
        }
        if (!(timedoutRequests = this.findTimedoutRequests()).isEmpty()) {
            this.resendRequests(timedoutRequests);
        }
        if (!this.pendingRespones.isEmpty()) {
            this.receiveResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequests() {
        ArrayList<UnsetRequest> unsentRequestsCopy;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            unsentRequestsCopy = new ArrayList<UnsetRequest>(this.unsentRequests);
        }
        for (UnsetRequest request : unsentRequestsCopy) {
            if (!this.canSendRequest(request.tracker, request.payload.getAction())) continue;
            TrackerRequest wrappedRequest = new TrackerRequest(request.tracker, this.torrentClient.createUniqueTransactionId(), request.payload);
            Object object = this.lock;
            synchronized (object) {
                this.pendingRespones.put(wrappedRequest.getTransactionId(), new SentRequest(wrappedRequest, this.clock));
            }
            try {
                this.writeRequest(wrappedRequest);
                object = this.lock;
                synchronized (object) {
                    this.unsentRequests.remove(request);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Tracker request failed to write: {}, resubmitted request.", (Object)wrappedRequest, (Object)e);
                Object object2 = this.lock;
                synchronized (object2) {
                    this.pendingRespones.remove(wrappedRequest.getTransactionId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<SentRequest> findTimedoutRequests() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingRespones.values().stream().filter(SentRequest::isTimedout).collect(Collectors.toList());
        }
    }

    private void resendRequests(Collection<SentRequest> timedoutRequests) {
        for (SentRequest pendingResponse : timedoutRequests) {
            if (!this.canResendRequest(pendingResponse)) continue;
            try {
                this.writeRequest(pendingResponse.request);
                pendingResponse.attempt++;
            }
            catch (IOException e) {
                LOGGER.warn("Tracker request failed to write: {}. Delayed resend of timedout request.", (Object)pendingResponse.request, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canResendRequest(SentRequest pendingResponse) {
        if (pendingResponse.attempt == 8) {
            LOGGER.warn("Tracker failed to respond to {} after 8 attempts. Discarding request.", (Object)pendingResponse.request);
            Object object = this.lock;
            synchronized (object) {
                this.pendingRespones.remove(pendingResponse.request.getTransactionId());
            }
            pendingResponse.request.onFailure();
            return false;
        }
        return this.canSendRequest(pendingResponse.request.getTracker(), pendingResponse.request.getAction());
    }

    private boolean canSendRequest(UdpTracker tracker, TrackerAction action) {
        if (tracker.getConnection().isValidFor(action, this.clock)) {
            return true;
        }
        if (!this.isConnectRequestQueued(tracker)) {
            LOGGER.debug("Refreshing connection ID for tracker: {}.", (Object)tracker);
            tracker.setConnection(new Connection(this.clock));
            this.submitRequest(tracker, new ConnectionRequest(this.clock));
        }
        return false;
    }

    private void writeRequest(TrackerRequest wrappedRequest) throws IOException {
        LOGGER.trace("Sending tracker request: {}.", (Object)wrappedRequest);
        OutStream outStream = new OutStream();
        wrappedRequest.writeRequest(outStream);
        this.socketUtils.write(this.udpSocket, wrappedRequest.getTracker().getSocketAddress(), outStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConnectRequestQueued(UdpTracker tracker) {
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingRespones.values().stream().filter(pendingRequest -> ((SentRequest)pendingRequest).request.getTracker().equals(tracker)).anyMatch(pendingRequest -> ((SentRequest)pendingRequest).request.getAction() == TrackerAction.CONNECT)) {
                return true;
            }
            if (this.unsentRequests.stream().filter(unsentRequest -> ((UnsetRequest)unsentRequest).tracker.equals(tracker)).anyMatch(unsetRequest -> ((UnsetRequest)unsetRequest).payload.getAction() == TrackerAction.CONNECT)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveResponse() {
        SentRequest sentRequest;
        InStream inStream;
        try {
            inStream = this.socketUtils.read(this.udpSocket);
        }
        catch (IOException e) {
            LOGGER.warn("Tracker request failed to read.", (Throwable)e);
            return;
        }
        int transactionId = this.peekTransactionId(inStream);
        Object object = this.lock;
        synchronized (object) {
            sentRequest = this.pendingRespones.remove(transactionId);
        }
        if (sentRequest == null) {
            LOGGER.warn("Received response with an unknown transaction id: {}", (Object)transactionId);
            return;
        }
        try {
            sentRequest.request.readResponse(inStream);
            sentRequest.request.process();
        }
        catch (TrackerException e) {
            LOGGER.warn("Failed to process tracker response for {}", (Object)sentRequest.request, (Object)e);
        }
    }

    public void shutdown() {
        this.keepRunning = false;
        this.taskLock.lock();
        try {
            this.newWork.signalAll();
        }
        finally {
            this.taskLock.unlock();
        }
    }

    private int peekTransactionId(InStream inStream) {
        inStream.mark();
        inStream.readInt();
        int transactionId = inStream.readInt();
        inStream.resetToMark();
        return transactionId;
    }

    public static final class Builder {
        private TorrentClient torrentClient;
        private UdpSocketUtils socketUtils;
        private int socketPort;
        private Clock clock = Clock.systemDefaultZone();

        public Builder setClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder setTorrentClient(TorrentClient torrentClient) {
            this.torrentClient = torrentClient;
            return this;
        }

        public Builder setSocketUtils(UdpSocketUtils socketUtils) {
            this.socketUtils = socketUtils;
            return this;
        }

        public Builder setSocketPort(int socketPort) {
            this.socketPort = socketPort;
            return this;
        }

        public UdpTrackerSocket build() throws TrackerException {
            return new UdpTrackerSocket(this);
        }
    }

    private static final class SentRequest {
        private final TrackerRequest request;
        private final Clock clock;
        private LocalDateTime sentTime;
        private int attempt;

        public SentRequest(TrackerRequest request, Clock clock) {
            this.request = request;
            this.clock = clock;
            this.sentTime = LocalDateTime.ofInstant(clock.instant(), clock.getZone());
        }

        public boolean isTimedout() {
            Duration timeoutPeriod = Duration.ofSeconds(15L * (long)((int)Math.pow(2.0, this.attempt)));
            Duration timeSinceRequest = Duration.between(this.sentTime, LocalDateTime.now(this.clock));
            if (timeSinceRequest.minus(timeoutPeriod).isNegative()) {
                LOGGER.trace("Request not timed out: {}, Sent: {}", (Object)LocalDateTime.now(this.clock), (Object)this.sentTime);
                return false;
            }
            return true;
        }
    }

    private static final class UnsetRequest {
        private final IUdpTrackerPayload payload;
        private final UdpTracker tracker;

        public UnsetRequest(UdpTracker tracker, IUdpTrackerPayload payload) {
            this.tracker = tracker;
            this.payload = payload;
        }
    }
}

