/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.tracker;

import java.util.Collections;
import java.util.List;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerException;
import org.johnnei.javatorrent.internal.tracker.udp.UdpTrackerSocket;
import org.johnnei.javatorrent.module.IModule;
import org.johnnei.javatorrent.module.ModuleBuildException;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.johnnei.javatorrent.tracker.UdpTracker;

public class UdpTrackerModule
implements IModule {
    private UdpTrackerSocket socket;
    private int trackerPort;

    public UdpTrackerModule(Builder builder) {
        this.trackerPort = builder.port;
    }

    public void configureTorrentClient(TorrentClient.Builder builder) {
        builder.registerTrackerProtocol("udp", (trackerUrl, torrentClient) -> new UdpTracker.Builder().setTorrentClient((TorrentClient)torrentClient).setSocket(this.socket).setUrl((String)trackerUrl).build());
    }

    public int getRelatedBep() {
        return 15;
    }

    public List<Class<IModule>> getDependsOn() {
        return Collections.emptyList();
    }

    public void onPostHandshake(Peer peer) {
    }

    public void onBuild(TorrentClient torrentClient) throws ModuleBuildException {
        try {
            this.socket = new UdpTrackerSocket.Builder().setTorrentClient(torrentClient).setSocketPort(this.trackerPort).build();
            Thread thread = new Thread((Runnable)this.socket, "UdpTracker Worker Thread");
            thread.setDaemon(true);
            thread.start();
        }
        catch (TrackerException e) {
            throw new ModuleBuildException("Failed to initialize tracker", (Throwable)e);
        }
    }

    public void onShutdown() {
        this.socket.shutdown();
    }

    public static final class Builder {
        private int port;

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public UdpTrackerModule build() {
            return new UdpTrackerModule(this);
        }
    }
}

