/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.tracker.udp;

import java.util.Objects;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerAction;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerException;
import org.johnnei.javatorrent.internal.tracker.udp.IUdpTrackerPayload;
import org.johnnei.javatorrent.network.InStream;
import org.johnnei.javatorrent.network.OutStream;
import org.johnnei.javatorrent.tracker.UdpTracker;

public class TrackerRequest {
    private UdpTracker tracker;
    private final IUdpTrackerPayload message;
    private final int transactionId;

    public TrackerRequest(UdpTracker tracker, int transactionId, IUdpTrackerPayload message) {
        this.tracker = Objects.requireNonNull(tracker);
        this.transactionId = transactionId;
        this.message = Objects.requireNonNull(message);
    }

    public void writeRequest(OutStream outStream) {
        outStream.writeLong(this.tracker.getConnection().getId());
        outStream.writeInt(this.message.getAction().getId());
        outStream.writeInt(this.transactionId);
        this.message.writeRequest(outStream);
    }

    public void readResponse(InStream inStream) throws TrackerException {
        TrackerAction action = TrackerAction.of((int)inStream.readInt());
        if (action == TrackerAction.ERROR) {
            String error = inStream.readString(inStream.available());
            throw new TrackerException(String.format("Tracker responded with an error: %s", error));
        }
        int responseTransactionId = inStream.readInt();
        if (responseTransactionId != this.transactionId) {
            throw new TrackerException(String.format("Expected transaction id %d but found %d, rejecting response.", this.transactionId, responseTransactionId));
        }
        this.message.readResponse(inStream);
    }

    public void process() {
        this.message.process(this.tracker);
    }

    public String toString() {
        return "TrackerRequest [transactionId=" + this.transactionId + ", message=" + this.message + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.transactionId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrackerRequest)) {
            return false;
        }
        TrackerRequest other = (TrackerRequest)obj;
        return this.transactionId == other.transactionId;
    }

    public TrackerAction getAction() {
        return this.message.getAction();
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public UdpTracker getTracker() {
        return this.tracker;
    }

    public void onFailure() {
        this.tracker.onRequestFailed(this.message);
    }
}

