/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.tracker.udp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import org.johnnei.javatorrent.bittorrent.tracker.TorrentInfo;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerAction;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerEvent;
import org.johnnei.javatorrent.internal.tracker.udp.IUdpTrackerPayload;
import org.johnnei.javatorrent.network.InStream;
import org.johnnei.javatorrent.network.OutStream;
import org.johnnei.javatorrent.network.PeerConnectInfo;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.tracker.UdpTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnounceRequest
implements IUdpTrackerPayload {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnounceRequest.class);
    private static final int AMOUNT_OF_WANTED_PEERS = 50;
    private static final int RESPOND_ON_SENDER_IP = 0;
    private static final int TRACKER_EXTENSIONS = 0;
    private final TorrentInfo torrentInfo;
    private final Torrent torrent;
    private final byte[] peerId;
    private final int downloadPort;
    private Collection<SocketInfo> sockets;
    private int leechers;
    private int seeders;
    private int interval;

    public AnnounceRequest(TorrentInfo torrentInfo, byte[] peerId, int downloadPort) {
        this.torrentInfo = Objects.requireNonNull(torrentInfo);
        this.torrent = torrentInfo.getTorrent();
        this.peerId = Objects.requireNonNull(peerId);
        this.downloadPort = downloadPort;
        if (peerId.length != 20) {
            throw new IllegalArgumentException(String.format("Given peer ID is %d bytes instead of the expected 20.", peerId.length));
        }
        this.sockets = new ArrayList<SocketInfo>();
    }

    @Override
    public void writeRequest(OutStream outStream) {
        outStream.write(this.torrent.getMetadata().getHash());
        outStream.write(this.peerId);
        outStream.writeLong(this.torrent.getDownloadedBytes());
        if (this.torrent.getFileSet() != null) {
            outStream.writeLong(this.torrent.getFileSet().countRemainingBytes());
        } else {
            outStream.writeLong(0L);
        }
        outStream.writeLong(this.torrent.getUploadedBytes());
        TrackerEvent event = this.torrentInfo.getEvent();
        outStream.writeInt(event.getId());
        if (event != TrackerEvent.EVENT_NONE) {
            this.torrentInfo.setEvent(TrackerEvent.EVENT_NONE);
        }
        outStream.writeInt(0);
        outStream.writeInt(new Random().nextInt());
        outStream.writeInt(50);
        outStream.writeShort(this.downloadPort);
        outStream.writeShort(0);
    }

    @Override
    public void readResponse(InStream inStream) {
        int bytesPerPeer = 6;
        this.interval = inStream.readInt();
        this.leechers = inStream.readInt();
        this.seeders = inStream.readInt();
        if (inStream.available() % 6 != 0) {
            LOGGER.warn(String.format("Peer information bytes aren't divisible by 6: %d", inStream.available()));
        }
        while (inStream.available() >= 6) {
            byte[] ip = inStream.readFully(4);
            int port = inStream.readUnsignedShort();
            this.sockets.add(new SocketInfo(ip, port));
        }
    }

    @Override
    public void process(UdpTracker tracker) {
        this.torrentInfo.setInfo(this.seeders, this.leechers);
        tracker.setAnnounceInterval(this.interval);
        this.sockets.stream().filter(this::isValidSocket).map(socket -> {
            InetSocketAddress socketAddress;
            try {
                socketAddress = new InetSocketAddress(InetAddress.getByAddress(((SocketInfo)socket).ip), ((SocketInfo)socket).port);
            }
            catch (Exception e) {
                LOGGER.debug("Discarding invalid socket for peer", (Throwable)e);
                return Optional.empty();
            }
            return Optional.of(new PeerConnectInfo(this.torrent, socketAddress));
        }).filter(peer -> peer.isPresent()).map(peer -> (PeerConnectInfo)peer.get()).forEach(tracker::connectPeer);
    }

    private boolean isValidSocket(SocketInfo socket) {
        for (int i = 0; i < socket.ip.length; ++i) {
            if (socket.ip[i] == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public TrackerAction getAction() {
        return TrackerAction.ANNOUNCE;
    }

    @Override
    public int getMinimalSize() {
        return 12;
    }

    private static final class SocketInfo {
        private final byte[] ip;
        private final int port;

        public SocketInfo(byte[] ip, int port) {
            this.ip = ip;
            this.port = port;
        }
    }
}

