/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.tracker;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.bittorrent.tracker.ITracker;
import org.johnnei.javatorrent.bittorrent.tracker.TorrentInfo;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerException;
import org.johnnei.javatorrent.internal.tracker.udp.AnnounceRequest;
import org.johnnei.javatorrent.internal.tracker.udp.Connection;
import org.johnnei.javatorrent.internal.tracker.udp.IUdpTrackerPayload;
import org.johnnei.javatorrent.internal.tracker.udp.ScrapeRequest;
import org.johnnei.javatorrent.internal.tracker.udp.UdpTrackerSocket;
import org.johnnei.javatorrent.network.PeerConnectInfo;
import org.johnnei.javatorrent.torrent.Torrent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpTracker
implements ITracker {
    private static final int DEFAULT_SCRAPE_INTERVAL = 10000;
    public static final String STATE_ANNOUNCING = "Announcing";
    public static final String STATE_SCRAPING = "Scraping";
    public static final String STATE_CONNECTING = "Connecting";
    public static final String STATE_IDLE = "Idle";
    public static final String STATE_CRASHED = "Invalid tracker";
    private static final Logger LOGGER = LoggerFactory.getLogger(UdpTracker.class);
    private final String url;
    private final TorrentClient torrentClient;
    private Clock clock;
    private UdpTrackerSocket trackerSocket;
    private Map<Torrent, TorrentInfo> torrentMap;
    private LocalDateTime lastScrapeTime;
    private int announceInterval;
    private InetSocketAddress trackerAddress;
    private Connection activeConnection;
    private String name;
    private String status;

    protected UdpTracker(Builder builder) throws TrackerException {
        this.url = Objects.requireNonNull(builder.trackerUrl, "Tracker URL must be given");
        this.torrentClient = builder.torrentClient;
        this.clock = builder.clock;
        this.trackerSocket = builder.socket;
        this.activeConnection = new Connection(this.clock);
        this.torrentMap = new HashMap<Torrent, TorrentInfo>();
        this.announceInterval = (int)Duration.ofSeconds(30L).toMillis();
        this.lastScrapeTime = LocalDateTime.now(this.clock).minus(10000L, ChronoUnit.MILLIS);
        Pattern regex = Pattern.compile("udp://([^:]+):(\\d+)");
        Matcher matcher = regex.matcher(builder.trackerUrl);
        if (!matcher.matches()) {
            throw new TrackerException(String.format("Tracker url doesn't match the expected format. URL: %s", builder.trackerUrl));
        }
        try {
            this.name = matcher.group(1);
            InetAddress address = InetAddress.getByName(matcher.group(1));
            int port = Integer.parseInt(matcher.group(2));
            this.trackerAddress = new InetSocketAddress(address, port);
            this.status = STATE_IDLE;
        }
        catch (Exception e) {
            this.name = "Unknown";
            this.status = STATE_CRASHED;
            LOGGER.warn(String.format("Failed to resolve tracker: %s", builder.trackerUrl), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTorrent(Torrent torrent) {
        UdpTracker udpTracker = this;
        synchronized (udpTracker) {
            if (!this.torrentMap.containsKey(torrent)) {
                this.torrentMap.put(torrent, new TorrentInfo(torrent, this.clock));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTorrent(Torrent torrent) {
        UdpTracker udpTracker = this;
        synchronized (udpTracker) {
            return this.torrentMap.containsKey(torrent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<TorrentInfo> getInfo(Torrent torrent) {
        UdpTracker udpTracker = this;
        synchronized (udpTracker) {
            return Optional.ofNullable(this.torrentMap.get(torrent));
        }
    }

    public void connectPeer(PeerConnectInfo peer) {
        this.torrentClient.getPeerConnector().enqueuePeer(peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrape() {
        if (Duration.between(this.lastScrapeTime, LocalDateTime.now(this.clock)).compareTo(Duration.of(10000L, ChronoUnit.MILLIS)) < 0) {
            return;
        }
        UdpTracker udpTracker = this;
        synchronized (udpTracker) {
            this.torrentMap.values().stream().map(torrentInfo -> torrentInfo.getTorrent()).forEach(torrent -> this.trackerSocket.submitRequest(this, new ScrapeRequest(Collections.singletonList(torrent))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void announce(Torrent torrent) {
        TorrentInfo torrentInfo;
        UdpTracker udpTracker = this;
        synchronized (udpTracker) {
            torrentInfo = this.torrentMap.get(torrent);
        }
        if (torrentInfo.getTimeSinceLastAnnounce().compareTo(Duration.of(this.announceInterval, ChronoUnit.MILLIS)) < 0) {
            return;
        }
        this.trackerSocket.submitRequest(this, new AnnounceRequest(torrentInfo, this.torrentClient.getPeerId(), this.torrentClient.getDownloadPort()));
    }

    public void onRequestFailed(IUdpTrackerPayload payload) {
        LOGGER.warn("Failed to execute {}.", (Object)payload);
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    public String toString() {
        return "UdpTracker [name=" + this.name + ", status=" + this.status + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.url.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UdpTracker)) {
            return false;
        }
        UdpTracker other = (UdpTracker)obj;
        return Objects.equals(this.url, other.url);
    }

    public void setConnection(Connection connection) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Received new connection: %s", connection));
        }
        this.activeConnection = connection;
    }

    public Connection getConnection() {
        return this.activeConnection;
    }

    public void setAnnounceInterval(int interval) {
        this.announceInterval = interval;
    }

    public InetSocketAddress getSocketAddress() {
        return this.trackerAddress;
    }

    public static final class Builder {
        private Clock clock = Clock.systemDefaultZone();
        private UdpTrackerSocket socket;
        private String trackerUrl;
        private TorrentClient torrentClient;

        public Builder setTorrentClient(TorrentClient torrentClient) {
            this.torrentClient = torrentClient;
            return this;
        }

        public Builder setClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder setSocket(UdpTrackerSocket socket) {
            this.socket = socket;
            return this;
        }

        public Builder setUrl(String trackerUrl) {
            this.trackerUrl = trackerUrl;
            return this;
        }

        public UdpTracker build() throws TrackerException {
            return new UdpTracker(this);
        }
    }
}

