/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.network.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import org.johnnei.javatorrent.internal.network.socket.ISocket;
import org.johnnei.javatorrent.internal.network.socket.UtpSocketImpl;
import org.johnnei.javatorrent.internal.utp.protocol.ConnectionState;
import org.johnnei.javatorrent.internal.utp.protocol.UtpMultiplexer;

public class UtpSocket
implements ISocket {
    private UtpSocketImpl.Builder socketFactory;
    private UtpSocketImpl socket;
    private UtpMultiplexer multiplexer;

    public UtpSocket(UtpMultiplexer utpMultiplexer) {
        this.multiplexer = utpMultiplexer;
        this.socketFactory = new UtpSocketImpl.Builder().setUtpMultiplexer(this.multiplexer);
    }

    public UtpSocket(UtpMultiplexer utpMultiplexer, UtpSocketImpl socket) {
        this.multiplexer = utpMultiplexer;
        this.socket = socket;
    }

    public void connect(InetSocketAddress endpoint) throws IOException {
        this.socketFactory.setSocketAddress(endpoint);
        do {
            this.socket = this.socketFactory.build();
        } while (!this.multiplexer.registerSocket(this.socket));
        this.socket.connect(endpoint);
    }

    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public boolean isClosed() {
        return this.socket == null || this.socket.getConnectionState() == ConnectionState.CLOSED;
    }

    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    public void flush() throws IOException {
        this.getOutputStream().flush();
    }
}

