/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.utp;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.johnnei.javatorrent.internal.utp.protocol.UtpPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtpTimeout {
    private static final Logger LOGGER = LoggerFactory.getLogger(UtpTimeout.class);
    private Duration timeout = Duration.of(1000L, ChronoUnit.MILLIS);
    private int rtt;
    private int rttVariance;

    public void update(int receiveTime, UtpPacket packet) {
        if (packet.getTimesSent() > 1) {
            return;
        }
        int packetRtt = receiveTime - packet.getSentTime();
        int delta = this.rtt - packetRtt;
        this.rttVariance += (Math.abs(delta) - this.rttVariance) / 4;
        this.rtt += (packetRtt - this.rtt) / 8;
        Duration oldTimeout = this.timeout;
        this.timeout = Duration.of(Math.max((this.rtt + this.rttVariance * 4) / 1000, 500), ChronoUnit.MILLIS);
        LOGGER.trace("Timeout changed from {}ms to {}ms", (Object)oldTimeout.toMillis(), (Object)this.timeout.toMillis());
    }

    public Duration getDuration() {
        return this.timeout;
    }
}

