/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.utp;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.johnnei.javatorrent.internal.network.socket.UtpSocketImpl;
import org.johnnei.javatorrent.internal.utils.MathUtils;
import org.johnnei.javatorrent.internal.utp.SlidingTimedValue;
import org.johnnei.javatorrent.internal.utp.protocol.UtpPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtpWindow {
    private static final Logger LOGGER = LoggerFactory.getLogger(UtpWindow.class);
    private static final long CONGESTION_CONTROL_TARGET = Duration.of(100L, ChronoUnit.MILLIS).toNanos() / 1000L;
    private static final int MAX_WINDOW_CHANGE_PER_PACKET = 100;
    private UtpSocketImpl socket;
    private SlidingTimedValue<Integer> slidingBaseDelay;
    private int maxWindow;

    public UtpWindow(UtpSocketImpl socket) {
        this.socket = socket;
        this.slidingBaseDelay = new SlidingTimedValue();
        this.maxWindow = 150;
    }

    public void update(UtpPacket packet) {
        this.slidingBaseDelay.addValue(packet.getTimestampDifferenceMicroseconds());
        long ourDelay = Integer.toUnsignedLong(packet.getTimestampDifferenceMicroseconds()) - Integer.toUnsignedLong(this.slidingBaseDelay.getMinimum());
        long offTarget = CONGESTION_CONTROL_TARGET - ourDelay;
        double delayFactor = MathUtils.clamp(-1.0, 1.0, (double)offTarget / (double)CONGESTION_CONTROL_TARGET);
        double windowFactor = MathUtils.clamp(-1.0, 1.0, (double)this.socket.getBytesInFlight() / (double)this.maxWindow);
        int scaledGain = (int)(100.0 * delayFactor * windowFactor);
        this.maxWindow += scaledGain;
        LOGGER.trace("Base Delay: {}us, Packet Delay: {}us, Delay: {}us, Off Target: {}us, Delay Factor: {}, Window Factor: {}.", new Object[]{this.slidingBaseDelay.getMinimum(), packet.getTimestampDifferenceMicroseconds(), ourDelay, offTarget, delayFactor, windowFactor});
        LOGGER.trace("Updated window size based on ACK. Window changed by {}, Now: {}", (Object)scaledGain, (Object)this.maxWindow);
    }

    public int getSize() {
        return this.maxWindow;
    }

    public void onTimeout() {
        this.maxWindow += 150;
    }
}

