/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.utp.protocol;

import java.io.IOException;
import org.johnnei.javatorrent.internal.network.socket.UtpSocketImpl;
import org.johnnei.javatorrent.internal.utils.PrecisionTimer;
import org.johnnei.javatorrent.internal.utp.protocol.payload.IPayload;
import org.johnnei.javatorrent.internal.utp.protocol.payload.UtpPayloadFactory;
import org.johnnei.javatorrent.network.InStream;
import org.johnnei.javatorrent.network.OutStream;

public class UtpPacket {
    private PrecisionTimer timer = new PrecisionTimer();
    private int sentTime;
    private int timesSent;
    private byte type;
    private byte version;
    private byte extension;
    private short connectionId;
    private int timestampMicroseconds;
    private int timestampDifferenceMicroseconds;
    private int windowSize;
    private short sequenceNumber;
    private short acknowledgeNumber;
    private IPayload payload;

    public UtpPacket() {
    }

    public UtpPacket(UtpSocketImpl socket, IPayload payload) {
        this(socket, payload, false);
    }

    public UtpPacket(UtpSocketImpl socket, IPayload payload, boolean isSynResponse) {
        this.version = 1;
        this.type = payload.getType();
        this.payload = payload;
        this.sequenceNumber = this.type == 2 && !isSynResponse ? socket.getSequenceNumber() : socket.nextSequenceNumber();
        this.connectionId = this.type == 4 ? socket.getReceivingConnectionId() : socket.getSendingConnectionId();
    }

    public void read(InStream inStream, UtpPayloadFactory payloadFactory) {
        byte typeAndVersion = inStream.readByte();
        this.version = (byte)(typeAndVersion & 0xF);
        if (this.version != 1) {
            return;
        }
        this.type = (byte)(typeAndVersion >>> 4);
        this.payload = payloadFactory.createPayloadFromType(this.type);
        this.extension = inStream.readByte();
        this.connectionId = inStream.readShort();
        this.timestampMicroseconds = inStream.readInt();
        this.timestampDifferenceMicroseconds = inStream.readInt();
        this.windowSize = inStream.readInt();
        this.sequenceNumber = inStream.readShort();
        this.acknowledgeNumber = inStream.readShort();
        this.payload.read(inStream);
    }

    public void write(UtpSocketImpl socket, OutStream outStream) {
        int typeAndVersion = this.type << 4 | this.version & 0xF;
        outStream.writeByte(typeAndVersion);
        outStream.writeByte(0);
        outStream.writeShort((int)this.connectionId);
        outStream.writeInt(this.timer.getCurrentMicros());
        outStream.writeInt(socket.getMeasuredDelay());
        outStream.writeInt(socket.getWindowSize());
        outStream.writeShort((int)this.sequenceNumber);
        this.acknowledgeNumber = socket.getAcknowledgeNumber();
        outStream.writeShort((int)this.acknowledgeNumber);
        this.payload.write(outStream);
    }

    public void updateSentTime() {
        this.sentTime = this.timer.getCurrentMicros();
        ++this.timesSent;
    }

    public void processPayload(UtpSocketImpl socket) throws IOException {
        this.payload.process(this, socket);
    }

    public short getConnectionId() {
        return this.connectionId;
    }

    public short getAcknowledgeNumber() {
        return this.acknowledgeNumber;
    }

    public short getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public int getTimestampMicroseconds() {
        return this.timestampMicroseconds;
    }

    public int getTimestampDifferenceMicroseconds() {
        return this.timestampDifferenceMicroseconds;
    }

    public boolean hasExtensions() {
        return this.extension != 0;
    }

    public byte getVersion() {
        return this.version;
    }

    public int getPacketSize() {
        return 20 + this.payload.getSize();
    }

    public int getSentTime() {
        return this.sentTime;
    }

    public int getTimesSent() {
        return this.timesSent;
    }

    public byte getType() {
        return this.type;
    }

    public String toString() {
        return String.format("UtpPacket[payload=%s, seq=%s, ack=%s]", this.payload, Short.toUnsignedInt(this.sequenceNumber), Short.toUnsignedInt(this.acknowledgeNumber));
    }
}

