/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.network;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.internal.network.socket.ISocket;
import org.johnnei.javatorrent.internal.network.socket.UtpSocket;
import org.johnnei.javatorrent.internal.utils.Sync;
import org.johnnei.javatorrent.network.AbstractPeerConnectionAcceptor;

public class UtpPeerConnectionAcceptor
extends AbstractPeerConnectionAcceptor {
    private final Lock notifyLock = new ReentrantLock();
    private final Condition onNewConnection = this.notifyLock.newCondition();
    private final Queue<UtpSocket> socketQueue = new LinkedList<UtpSocket>();

    public UtpPeerConnectionAcceptor(TorrentClient torrentClient) {
        super(torrentClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceivedConnection(UtpSocket socket) {
        UtpPeerConnectionAcceptor utpPeerConnectionAcceptor = this;
        synchronized (utpPeerConnectionAcceptor) {
            this.socketQueue.add(socket);
        }
        Sync.signalAll(this.notifyLock, this.onNewConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISocket acceptSocket() throws IOException {
        this.notifyLock.lock();
        try {
            while (!this.hasPendingConnection()) {
                this.onNewConnection.await();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for a new connection", e);
        }
        finally {
            this.notifyLock.unlock();
        }
        UtpPeerConnectionAcceptor utpPeerConnectionAcceptor = this;
        synchronized (utpPeerConnectionAcceptor) {
            return this.socketQueue.poll();
        }
    }

    private synchronized boolean hasPendingConnection() {
        return !this.socketQueue.isEmpty();
    }
}

