/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.utp.protocol;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.johnnei.javatorrent.internal.network.socket.UtpSocketImpl;
import org.johnnei.javatorrent.internal.utils.RecentLinkedList;
import org.johnnei.javatorrent.internal.utp.protocol.UtpPacket;
import org.johnnei.javatorrent.internal.utp.protocol.payload.StatePayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtpAckHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(UtpAckHandler.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Set<Short> futurePackets;
    private final UtpSocketImpl socket;
    private final Collection<UtpPacket> packetsInFlight;
    private AtomicBoolean firstPacket;
    private short acknowledgeNumber;
    private RecentLinkedList<Acknowledgement> acknowledgements;

    public UtpAckHandler(UtpSocketImpl socket) {
        this.socket = socket;
        this.packetsInFlight = new LinkedList<UtpPacket>();
        this.acknowledgements = new RecentLinkedList(10);
        this.futurePackets = new HashSet<Short>();
        this.firstPacket = new AtomicBoolean(true);
    }

    public void registerPacket(UtpPacket packet) {
        if (packet.getTimesSent() != 0) {
            return;
        }
        if (packet.getType() == 2) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            Optional<UtpPacket> duplicatePacket = this.packetsInFlight.stream().filter(p -> packet.getSequenceNumber() == p.getSequenceNumber()).findAny();
            if (duplicatePacket.isPresent()) {
                return;
            }
            this.packetsInFlight.add(packet);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<UtpPacket> onReceivedPacket(UtpPacket receivedPacket) throws IOException {
        if (this.firstPacket.compareAndSet(true, false)) {
            LOGGER.trace("Initialised base acknowledgeNumber to be {}", (Object)Short.toUnsignedInt(receivedPacket.getSequenceNumber()));
            this.acknowledgeNumber = receivedPacket.getSequenceNumber();
            this.socket.bindIoStreams(this.acknowledgeNumber);
        } else {
            this.updateAcknowledgeNumber(receivedPacket);
        }
        Optional<UtpPacket> ackedPacket = Optional.empty();
        this.lock.readLock().lock();
        try {
            ackedPacket = this.packetsInFlight.stream().filter(packet -> packet.getSequenceNumber() == receivedPacket.getAcknowledgeNumber()).findAny();
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            this.packetsInFlight.removeIf(p -> p.getSequenceNumber() <= receivedPacket.getAcknowledgeNumber());
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.handleResend(receivedPacket);
        return ackedPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResend(UtpPacket packet) throws IOException {
        Acknowledgement acknowledgement = this.acknowledgements.putIfAbsent(new Acknowledgement(packet.getAcknowledgeNumber()));
        acknowledgement.incrementCount();
        if (acknowledgement.getCount() % 3 != 0) {
            return;
        }
        acknowledgement.resetCount();
        short nextSequenceNumber = (short)(packet.getAcknowledgeNumber() + 1);
        this.lock.readLock().lock();
        Optional<Object> lostPacketOptional = Optional.empty();
        try {
            lostPacketOptional = this.packetsInFlight.stream().filter(p -> p.getSequenceNumber() == nextSequenceNumber).findAny();
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (!lostPacketOptional.isPresent()) {
            if (this.socket.getSequenceNumber() > nextSequenceNumber) {
                LOGGER.trace("Packet seq={} appears to be lost, but we've seen an ACK for it so it can't be resend.", (Object)Short.toUnsignedInt(nextSequenceNumber));
            }
            return;
        }
        UtpPacket lostPacket = (UtpPacket)lostPacketOptional.get();
        LOGGER.trace("Resending lost packet {}", (Object)lostPacket);
        this.socket.sendUnbounded(lostPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAcknowledgeNumber(UtpPacket packet) throws IOException {
        if (packet.getType() == 2) {
            return;
        }
        Set<Short> set = this.futurePackets;
        synchronized (set) {
            short nextPacket;
            this.futurePackets.add(packet.getSequenceNumber());
            while (this.futurePackets.remove(nextPacket = (short)(this.acknowledgeNumber + 1))) {
                this.acknowledgeNumber = nextPacket;
                UtpPacket statePacket = new UtpPacket(this.socket, new StatePayload());
                LOGGER.trace("Sending ACK message for {}, caused by {}.", (Object)Short.toUnsignedInt(this.acknowledgeNumber), (Object)packet);
                this.socket.sendUnbounded(statePacket);
                LOGGER.trace("Sent ACK {} for {}.", (Object)statePacket, (Object)Short.toUnsignedInt(this.acknowledgeNumber));
            }
        }
    }

    public void onReset() {
        this.lock.writeLock().lock();
        try {
            this.packetsInFlight.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public short getAcknowledgeNumber() {
        return this.acknowledgeNumber;
    }

    public int countBytesInFlight() {
        this.lock.readLock().lock();
        try {
            int n = this.packetsInFlight.stream().mapToInt(UtpPacket::getPacketSize).sum();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean hasPacketsInFlight() {
        return !this.packetsInFlight.isEmpty();
    }

    public boolean isInitialised() {
        return !this.firstPacket.get();
    }

    public String toString() {
        this.lock.readLock().lock();
        try {
            String string = String.format("UtpAckHandler[ack=%d, packetsInFlight=[%s], bytes in flight=%d]", Short.toUnsignedInt(this.acknowledgeNumber), this.packetsInFlight.stream().map(p -> Integer.toString(Short.toUnsignedInt(p.getSequenceNumber()))).reduce((a, b) -> a + ", " + b).orElse(""), this.countBytesInFlight());
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private final class Acknowledgement {
        private final int sequenceNumber;
        private int count;

        Acknowledgement(int sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            this.count = 0;
        }

        void incrementCount() {
            ++this.count;
        }

        void resetCount() {
            this.count = 0;
        }

        int getCount() {
            return this.count;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof Acknowledgement)) {
                return false;
            }
            Acknowledgement that = (Acknowledgement)o;
            return this.sequenceNumber == that.sequenceNumber;
        }

        public int hashCode() {
            return Objects.hash(this.sequenceNumber);
        }
    }
}

