/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.utp.protocol;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.johnnei.javatorrent.internal.network.socket.UtpSocketImpl;
import org.johnnei.javatorrent.internal.utils.Sync;
import org.johnnei.javatorrent.internal.utp.protocol.payload.DataPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtpInputStream
extends InputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(UtpInputStream.class);
    private final Lock notifyLock = new ReentrantLock();
    private final Condition onPacketArrived = this.notifyLock.newCondition();
    private UtpSocketImpl socket;
    private short nextSequenceNumber;
    private HashMap<Short, DataPayload> packets;
    private byte[] readBuffer;
    private int position;

    public UtpInputStream(UtpSocketImpl socket, short initialSequenceNumber) {
        this.socket = socket;
        this.nextSequenceNumber = initialSequenceNumber;
        this.packets = new HashMap();
    }

    public void addToBuffer(short sequenceNumber, DataPayload dataPayload) {
        int expectedSequenceNumber = Short.toUnsignedInt(this.nextSequenceNumberToReceive());
        this.packets.putIfAbsent(sequenceNumber, dataPayload);
        LOGGER.trace("Received packet {} (expected: {}). Available: {}", new Object[]{Short.toUnsignedInt(sequenceNumber), expectedSequenceNumber, this.available()});
        Sync.signalAll(this.notifyLock, this.onPacketArrived);
    }

    @Override
    public int read() throws IOException {
        if (this.getAvailableBytesInCurrentBuffer() < 1) {
            this.readNextBuffer();
        }
        return this.readBuffer[this.position++] & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (length <= 0) {
            return 0;
        }
        int readLimit = Math.min(length, Math.max(1, this.available()));
        for (int i = 0; i < readLimit; ++i) {
            buffer[offset + i] = (byte)(this.read() & 0xFF);
        }
        return readLimit;
    }

    private void readNextBuffer() throws IOException {
        DataPayload payload = this.packets.remove(this.nextSequenceNumber);
        while (payload == null) {
            if (this.socket.getConnectionState().isClosedState() && this.nextSequenceNumber >= this.socket.getEndOfStreamSequenceNumber()) {
                throw new EOFException("InputStream has been shutdown by the remote end.");
            }
            this.notifyLock.lock();
            try {
                this.onPacketArrived.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while blocking for new data", e);
            }
            finally {
                this.notifyLock.unlock();
            }
            payload = this.packets.remove(this.nextSequenceNumber);
        }
        this.readBuffer = payload.getData();
        this.position = 0;
        this.nextSequenceNumber = (short)(this.nextSequenceNumber + 1);
    }

    private short nextSequenceNumberToReceive() {
        short sequenceNumber = this.nextSequenceNumber;
        while (this.packets.get(sequenceNumber) != null) {
            sequenceNumber = (short)(sequenceNumber + 1);
        }
        return sequenceNumber;
    }

    @Override
    public int available() {
        DataPayload payload;
        int sum = this.getAvailableBytesInCurrentBuffer();
        short sequenceNumber = this.nextSequenceNumber;
        while ((payload = this.packets.get(sequenceNumber)) != null) {
            sum += payload.getData().length;
            sequenceNumber = (short)(sequenceNumber + 1);
        }
        return sum;
    }

    private int getAvailableBytesInCurrentBuffer() {
        if (this.readBuffer == null) {
            return 0;
        }
        return this.readBuffer.length - this.position;
    }
}

