/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.utp.protocol;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.async.LoopingRunnable;
import org.johnnei.javatorrent.internal.network.UtpPeerConnectionAcceptor;
import org.johnnei.javatorrent.internal.network.socket.UtpSocket;
import org.johnnei.javatorrent.internal.network.socket.UtpSocketImpl;
import org.johnnei.javatorrent.internal.utp.UtpSocketRegistration;
import org.johnnei.javatorrent.internal.utp.protocol.UtpPacket;
import org.johnnei.javatorrent.internal.utp.protocol.payload.UtpPayloadFactory;
import org.johnnei.javatorrent.module.ModuleBuildException;
import org.johnnei.javatorrent.network.InStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtpMultiplexer
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(UtpMultiplexer.class);
    private final Object socketListLock = new Object();
    private TorrentClient torrentClient;
    private UtpPeerConnectionAcceptor connectionAcceptor;
    private LoopingRunnable connectionAcceptorRunnable;
    private UtpSocketImpl.Builder utpSocketFactory;
    private UtpPayloadFactory packetFactory;
    DatagramSocket multiplexerSocket;
    private Map<Short, UtpSocketRegistration> utpSockets;
    private int receiveBufferSize;
    Thread connectionAcceptorThread;

    public UtpMultiplexer(TorrentClient torrentClient) throws ModuleBuildException {
        this.torrentClient = torrentClient;
        this.utpSockets = new HashMap<Short, UtpSocketRegistration>();
        this.utpSocketFactory = new UtpSocketImpl.Builder().setUtpMultiplexer(this);
        this.packetFactory = new UtpPayloadFactory();
        this.connectionAcceptor = new UtpPeerConnectionAcceptor(torrentClient);
        this.connectionAcceptorRunnable = new LoopingRunnable((Runnable)((Object)this.connectionAcceptor));
        this.startMultiplexer(torrentClient.getDownloadPort());
    }

    void startMultiplexer(int port) throws ModuleBuildException {
        try {
            this.multiplexerSocket = new DatagramSocket(port);
            this.receiveBufferSize = this.multiplexerSocket.getReceiveBufferSize();
        }
        catch (IOException e) {
            throw new ModuleBuildException("Failed to bind to socket for uTP connections.", (Throwable)e);
        }
        this.connectionAcceptorThread = new Thread((Runnable)this.connectionAcceptorRunnable, "uTP Connection Acceptor");
        this.connectionAcceptorThread.setDaemon(true);
        this.connectionAcceptorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerSocket(UtpSocketImpl socket) {
        Object object = this.socketListLock;
        synchronized (object) {
            if (this.utpSockets.containsKey(socket.getReceivingConnectionId())) {
                return false;
            }
            ScheduledFuture<?> pollingTask = this.torrentClient.getExecutorService().scheduleAtFixedRate(() -> {
                try {
                    socket.handleTimeout();
                    socket.handleClose();
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to handle socket timeout/close cases. Triggering reset on socket.", (Throwable)e);
                    this.resetSocket(socket);
                }
            }, 1000L, 500L, TimeUnit.MILLISECONDS);
            this.utpSockets.put(socket.getReceivingConnectionId(), new UtpSocketRegistration(socket, pollingTask));
        }
        return true;
    }

    private void resetSocket(UtpSocketImpl socket) {
        try {
            socket.onReset();
        }
        catch (IOException e) {
            LOGGER.warn("Failed to trigger reset on socket, state is corrupted removing socket from system.", (Throwable)e);
            this.cleanUpSocket(socket);
        }
    }

    public void cleanUpSocket(UtpSocketImpl socket) {
        UtpSocketRegistration registration = this.utpSockets.remove(socket.getReceivingConnectionId());
        registration.getPollingTask().cancel(false);
    }

    public void send(DatagramPacket datagramPacket) throws IOException {
        this.multiplexerSocket.send(datagramPacket);
    }

    @Override
    public void run() {
        try {
            byte[] dataBuffer = new byte[25600];
            DatagramPacket packet = new DatagramPacket(dataBuffer, dataBuffer.length);
            this.multiplexerSocket.receive(packet);
            this.handlePacket(packet);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to process uTP packet", (Throwable)e);
        }
    }

    private void handlePacket(DatagramPacket packet) throws IOException {
        try {
            UtpSocketImpl socket;
            boolean newSocket = false;
            InStream inStream = new InStream(packet.getData(), packet.getOffset(), packet.getLength());
            UtpPacket utpPacket = new UtpPacket();
            utpPacket.read(inStream, this.packetFactory);
            UtpSocketRegistration socketRegistration = this.utpSockets.get(utpPacket.getConnectionId());
            if (socketRegistration == null) {
                LOGGER.debug("Received connection from {}", (Object)packet.getSocketAddress());
                this.utpSocketFactory.setSocketAddress(packet.getSocketAddress());
                socket = this.utpSocketFactory.build(utpPacket.getConnectionId());
                this.registerSocket(socket);
                newSocket = true;
            } else {
                socket = socketRegistration.getSocket();
            }
            socket.process(utpPacket);
            if (newSocket) {
                this.connectionAcceptor.onReceivedConnection(new UtpSocket(this, socket));
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Invalid Packet of {} bytes ({}:{}).", new Object[]{packet.getLength(), packet.getAddress(), packet.getPort(), e});
        }
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void shutdown() {
        this.multiplexerSocket.close();
        this.connectionAcceptorRunnable.stop();
        this.connectionAcceptorThread.interrupt();
    }
}

