/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.utp.protocol;

import java.io.IOException;
import java.io.OutputStream;
import org.johnnei.javatorrent.internal.network.socket.UtpSocketImpl;
import org.johnnei.javatorrent.internal.utp.protocol.payload.DataPayload;

public class UtpOutputStream
extends OutputStream {
    private UtpSocketImpl socket;
    private byte[] outBuffer;
    private int position;

    public UtpOutputStream(UtpSocketImpl socket) {
        this.socket = socket;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        int chunkLength;
        if (this.socket.getConnectionState().isClosedState()) {
            throw new IOException("Socket has been closed.");
        }
        this.ensureBufferSize();
        int readBytes = 0;
        for (int remainingBytes = length; remainingBytes > 0; remainingBytes -= chunkLength) {
            chunkLength = Math.min(this.outBuffer.length - this.position, remainingBytes);
            System.arraycopy(buffer, offset + readBytes, this.outBuffer, this.position, chunkLength);
            this.position += chunkLength;
            readBytes += chunkLength;
            if (this.position < this.outBuffer.length) continue;
            this.sendBuffer();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.position == 0) {
            return;
        }
        this.sendBuffer();
    }

    private void sendBuffer() throws IOException {
        byte[] outBufferClone = new byte[this.position];
        System.arraycopy(this.outBuffer, 0, outBufferClone, 0, outBufferClone.length);
        this.socket.send(new DataPayload(outBufferClone));
        this.position = 0;
    }

    private void ensureBufferSize() {
        if (this.outBuffer == null) {
            this.outBuffer = new byte[this.socket.getPacketSize()];
            return;
        }
        if (this.outBuffer.length < this.socket.getPacketSize()) {
            byte[] newBuffer = new byte[this.socket.getPacketSize()];
            System.arraycopy(this.outBuffer, 0, newBuffer, 0, this.outBuffer.length);
            this.outBuffer = newBuffer;
        }
    }
}

