/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.utp.protocol.payload;

import java.io.IOException;
import org.johnnei.javatorrent.internal.network.socket.UtpSocketImpl;
import org.johnnei.javatorrent.internal.utp.protocol.UtpPacket;
import org.johnnei.javatorrent.internal.utp.protocol.payload.IPayload;
import org.johnnei.javatorrent.network.InStream;
import org.johnnei.javatorrent.network.OutStream;

public class DataPayload
implements IPayload {
    private byte[] data;

    public DataPayload(byte[] data) {
        this.data = data;
    }

    public DataPayload() {
        this.data = new byte[0];
    }

    @Override
    public byte getType() {
        return 0;
    }

    @Override
    public void read(InStream inStream) {
        this.data = inStream.readFully(inStream.available());
    }

    @Override
    public void write(OutStream outStream) {
        outStream.write(this.data);
    }

    @Override
    public void process(UtpPacket packet, UtpSocketImpl socket) throws IOException {
        socket.onReceivedData();
        socket.getInputStream().addToBuffer(packet.getSequenceNumber(), this);
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public int getSize() {
        return this.data.length;
    }

    public String toString() {
        return String.format("DataPayload[length=%s]", this.data.length);
    }
}

