/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.utp;

import java.util.HashMap;
import java.util.Map;
import org.johnnei.javatorrent.internal.utp.Acknowledgement;
import org.johnnei.javatorrent.internal.utp.UtpSocket;
import org.johnnei.javatorrent.internal.utp.protocol.packet.UtpPacket;

public class PacketAckHandler {
    private final UtpSocket socket;
    private boolean isInitialized;
    private short acknowledgeNumber;
    private Map<Short, Acknowledgement> acknowledgements;

    public PacketAckHandler(UtpSocket socket) {
        this.socket = socket;
        this.acknowledgements = new HashMap<Short, Acknowledgement>();
        this.isInitialized = false;
    }

    public PacketAckHandler(UtpSocket socket, short acknowledgeNumber) {
        this.socket = socket;
        this.acknowledgements = new HashMap<Short, Acknowledgement>();
        this.acknowledgeNumber = acknowledgeNumber;
        this.isInitialized = true;
    }

    public void onReceivedPacket(UtpPacket packet) {
        short sequenceNumber = packet.getHeader().getSequenceNumber();
        Acknowledgement acknowledgement = this.acknowledgements.computeIfAbsent(sequenceNumber, Acknowledgement::new);
        acknowledgement.packetSeen();
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.acknowledgeNumber = sequenceNumber;
            this.socket.setAcknowledgeNumber(this.acknowledgeNumber);
        }
        while (acknowledgement != null && this.isNextPacketToAcknowledge(acknowledgement)) {
            this.socket.acknowledgePacket(acknowledgement);
            this.acknowledgeNumber = sequenceNumber;
            sequenceNumber = (short)(sequenceNumber + 1);
            acknowledgement = this.acknowledgements.get(sequenceNumber);
        }
    }

    private boolean isNextPacketToAcknowledge(Acknowledgement acknowledgement) {
        short nextPacket = (short)(this.acknowledgeNumber + 1);
        return acknowledgement.getSequenceNumber() == nextPacket;
    }
}

