/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.utp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.johnnei.javatorrent.internal.utp.UtpSocket;
import org.johnnei.javatorrent.internal.utp.protocol.PacketType;
import org.johnnei.javatorrent.internal.utp.protocol.packet.UtpPacket;

public class PacketLossHandler {
    private final UtpSocket socket;
    private final Map<Short, UtpPacket> packetsInFlight;
    private final Collection<UtpPacket> pendingResend;
    private int lastAck;
    private int duplicateCount;

    public PacketLossHandler(UtpSocket socket) {
        this.socket = socket;
        this.packetsInFlight = new HashMap<Short, UtpPacket>();
        this.pendingResend = new ArrayList<UtpPacket>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceivedPacket(UtpPacket packet) {
        if (Short.toUnsignedInt(packet.getHeader().getAcknowledgeNumber()) > this.lastAck) {
            this.lastAck = Short.toUnsignedInt(packet.getHeader().getAcknowledgeNumber());
            this.duplicateCount = 0;
        } else if (packet.getPayload().getType() == PacketType.STATE) {
            ++this.duplicateCount;
        }
        PacketLossHandler packetLossHandler = this;
        synchronized (packetLossHandler) {
            this.packetsInFlight.remove((short)(packet.getHeader().getAcknowledgeNumber() - 1));
            short nextPacketSeqNr = (short)(packet.getHeader().getAcknowledgeNumber() + 1);
            if (this.duplicateCount >= 3 && this.canResendPacket(nextPacketSeqNr)) {
                UtpPacket nextPacket = this.packetsInFlight.get(nextPacketSeqNr);
                this.socket.resend(nextPacket);
                this.pendingResend.add(nextPacket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSentPacket(UtpPacket packet) {
        PacketLossHandler packetLossHandler = this;
        synchronized (packetLossHandler) {
            this.packetsInFlight.computeIfAbsent(packet.getHeader().getSequenceNumber(), s -> packet).incrementSentCount();
            this.pendingResend.removeIf(p -> p.getHeader().getSequenceNumber() == packet.getHeader().getSequenceNumber());
        }
    }

    private boolean canResendPacket(short sequenceNumber) {
        return this.packetsInFlight.containsKey(sequenceNumber) && this.pendingResend.stream().noneMatch(packet -> packet.getHeader().getSequenceNumber() == sequenceNumber);
    }
}

