/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.utp;

import java.util.HashMap;
import java.util.Map;
import org.johnnei.javatorrent.internal.utp.SocketWindowHandler;
import org.johnnei.javatorrent.internal.utp.protocol.packet.UtpPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketSizeHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PacketSizeHandler.class);
    private static final int CHANGE_CONTROL = 150;
    private final SocketWindowHandler windowHandler;
    private final Map<Short, UtpPacket> packetsInFlight;
    private int packetSize;
    private int targetPacketCount;

    public PacketSizeHandler(SocketWindowHandler windowHandler) {
        this.windowHandler = windowHandler;
        this.packetsInFlight = new HashMap<Short, UtpPacket>();
        this.packetSize = 150;
        this.targetPacketCount = 10;
    }

    public void onSentPacket(UtpPacket packet) {
        this.packetsInFlight.put(packet.getHeader().getSequenceNumber(), packet);
    }

    public void onReceivedPacket(UtpPacket packet) {
        if (this.packetsInFlight.remove(packet.getHeader().getAcknowledgeNumber()) == null) {
            return;
        }
        this.targetPacketCount = Math.max(10, this.targetPacketCount - 1);
        this.setPacketSize(this.windowHandler.getMaxWindow() / this.targetPacketCount);
        LOGGER.trace("PacketSize update: [{}] target packets of [{}] bytes", (Object)this.targetPacketCount, (Object)this.packetSize);
    }

    public void onPacketLoss() {
        this.targetPacketCount *= 2;
    }

    private void setPacketSize(int packetSize) {
        this.packetSize = Math.max(150, packetSize);
    }

    public void onTimeout() {
        this.targetPacketCount = 10;
        this.packetSize = 150;
        LOGGER.trace("PacketSize timeout: {} target packets of {} bytes", (Object)this.targetPacketCount, (Object)this.packetSize);
    }

    public int getPacketSize() {
        return this.packetSize;
    }
}

