/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.utp;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.johnnei.javatorrent.internal.utils.PrecisionTimer;
import org.johnnei.javatorrent.internal.utp.protocol.packet.UtpPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketTimeoutHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketTimeoutHandler.class);
    private static final Duration MINIMUM_TIMEOUT = Duration.of(500L, ChronoUnit.MILLIS);
    private final PrecisionTimer timer;
    private Duration timeout;
    private int lastActivity;
    private int roundTripTime;
    private int roundTripTimeVariance;

    public SocketTimeoutHandler(PrecisionTimer timer) {
        this.timer = timer;
        this.lastActivity = timer.getCurrentMicros();
        this.timeout = Duration.of(1000L, ChronoUnit.MILLIS);
    }

    public void onReceivedPacket() {
        this.updateLastActivity();
    }

    public void onAckedPacket(UtpPacket packet) {
        int receiveTime = this.timer.getCurrentMicros();
        if (!packet.isSendOnce()) {
            LOGGER.trace("Ignoring re-sent packet [{}] for timeout adjustment.", (Object)Short.toUnsignedInt(packet.getHeader().getSequenceNumber()));
            return;
        }
        int packetRoundTripTime = receiveTime - packet.getHeader().getTimestamp();
        int delta = this.roundTripTime - packetRoundTripTime;
        int varianceAdjustment = (Math.abs(delta) - this.roundTripTimeVariance) / 4;
        int roundTripTimeAdjustment = (packetRoundTripTime - this.roundTripTime) / 8;
        this.roundTripTimeVariance += varianceAdjustment;
        this.roundTripTime += roundTripTimeAdjustment;
        Duration newTimeout = Duration.of((long)this.roundTripTime + (long)this.roundTripTimeVariance * 4L, ChronoUnit.MICROS);
        this.timeout = Duration.of(Math.max(newTimeout.toMillis(), MINIMUM_TIMEOUT.toMillis()), ChronoUnit.MILLIS);
        LOGGER.trace("Packet [{}] caused timeout to become [{}]. rtt += [{}], rtt_var += [{}]", new Object[]{Short.toUnsignedInt(packet.getHeader().getSequenceNumber()), this.timeout.toMillis(), roundTripTimeAdjustment, varianceAdjustment});
    }

    public void onSentPacket() {
        this.updateLastActivity();
    }

    public void updateLastActivity() {
        this.lastActivity = this.timer.getCurrentMicros();
    }

    public void onTimeout() {
        this.timeout = Duration.of(this.timeout.toMillis() * 2L, ChronoUnit.MILLIS);
    }

    public boolean isTimeoutExpired() {
        return Duration.of((long)this.timer.getCurrentMicros() - (long)this.lastActivity, ChronoUnit.MICROS).compareTo(this.timeout) > 0;
    }

    int getRoundTripTime() {
        return this.roundTripTime;
    }

    int getRoundTripTimeVariance() {
        return this.roundTripTimeVariance;
    }

    int getTimeout() {
        return (int)this.timeout.toMillis();
    }
}

