/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.utp;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.johnnei.javatorrent.internal.utils.SlidingTimedValue;
import org.johnnei.javatorrent.internal.utp.protocol.PacketType;
import org.johnnei.javatorrent.internal.utp.protocol.packet.UtpPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketWindowHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketWindowHandler.class);
    private static final Duration CCONTROL_TARGET = Duration.ofMillis(100L);
    private static final int MAX_WINDOW_CHANGE_PER_PACKET = 500;
    private int maxWindow = 150;
    private SlidingTimedValue<Integer> measuredDelays = new SlidingTimedValue();
    private Map<Short, UtpPacket> packetsInFlight = new HashMap<Short, UtpPacket>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<UtpPacket> onReceivedPacket(UtpPacket packet) {
        UtpPacket ackedPacket;
        int measuredDelay = packet.getHeader().getTimestampDifference();
        this.measuredDelays.addValue(measuredDelay);
        Duration ourDelay = Duration.of((long)measuredDelay - (long)this.measuredDelays.getMinimum().intValue(), ChronoUnit.MICROS);
        SocketWindowHandler socketWindowHandler = this;
        synchronized (socketWindowHandler) {
            ackedPacket = this.packetsInFlight.remove(packet.getHeader().getAcknowledgeNumber());
        }
        if (!ourDelay.isZero() && ackedPacket != null) {
            Duration offTarget = CCONTROL_TARGET.minus(ourDelay);
            double delayFactor = (double)offTarget.toNanos() / (double)CCONTROL_TARGET.toNanos();
            int ackedBytes = ackedPacket.getSize();
            double windowFactor = Math.min((double)ackedBytes, (double)this.maxWindow) / Math.max((double)ackedBytes, (double)this.maxWindow);
            int scaledGain = (int)(500.0 * delayFactor * windowFactor);
            this.maxWindow = Math.max(0, this.maxWindow + scaledGain);
            SocketWindowHandler socketWindowHandler2 = this;
            synchronized (socketWindowHandler2) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("our_delay: [{}] us, off_target: [{}] us, delayFactor [{}], windowFactor [{}], scaledGain [{}] bytes, maxWindow [{}] bytes, packets in flight: {}", new Object[]{ourDelay, offTarget, delayFactor, windowFactor, scaledGain, this.maxWindow, this.packetsInFlight.values().stream().map(p -> Short.toUnsignedInt(p.getHeader().getSequenceNumber()) + "-" + p.getSize()).collect(Collectors.toList())});
                }
            }
        }
        return Optional.ofNullable(ackedPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSentPacket(UtpPacket packet) {
        if (packet.getHeader().getType() != PacketType.DATA.getTypeField()) {
            return;
        }
        SocketWindowHandler socketWindowHandler = this;
        synchronized (socketWindowHandler) {
            this.packetsInFlight.putIfAbsent(packet.getHeader().getSequenceNumber(), packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBytesInFlight() {
        SocketWindowHandler socketWindowHandler = this;
        synchronized (socketWindowHandler) {
            return this.packetsInFlight.values().stream().map(UtpPacket::getSize).reduce((a, b) -> a + b).orElse(0);
        }
    }

    public int getMaxWindow() {
        return this.maxWindow;
    }

    public void onTimeout() {
        this.maxWindow = 150;
        LOGGER.trace("Timeout occurred. max_window=[{}]", (Object)this.maxWindow);
    }

    public void onPacketLoss(UtpPacket packet) {
        this.maxWindow /= 2;
        LOGGER.trace("Packet [{}] was lost. max_window=[{}]", (Object)Short.toUnsignedInt(packet.getHeader().getSequenceNumber()), (Object)this.maxWindow);
    }
}

