/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.utp;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.johnnei.javatorrent.async.LoopingRunnable;
import org.johnnei.javatorrent.internal.utp.UtpPeerConnectionAcceptor;
import org.johnnei.javatorrent.internal.utp.UtpSocket;
import org.johnnei.javatorrent.internal.utp.UtpSocketRegistry;
import org.johnnei.javatorrent.internal.utp.protocol.PacketType;
import org.johnnei.javatorrent.internal.utp.protocol.UtpProtocolViolationException;
import org.johnnei.javatorrent.internal.utp.protocol.packet.UtpPacket;
import org.johnnei.javatorrent.internal.utp.stream.PacketReader;
import org.johnnei.javatorrent.network.socket.ISocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtpMultiplexer
implements Closeable,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(UtpMultiplexer.class);
    private static final int BUFFER_SIZE = 32768;
    private final PacketReader packetReader;
    private final UtpSocketRegistry socketRegistry;
    private final UtpPeerConnectionAcceptor connectionAcceptor;
    private final LoopingRunnable connectionAcceptorRunnable;
    private final Thread connectionAcceptorThread;
    private DatagramChannel channel;

    public UtpMultiplexer(UtpPeerConnectionAcceptor connectionAcceptor, PacketReader packetReader, int port) throws IOException {
        this.connectionAcceptor = connectionAcceptor;
        this.packetReader = packetReader;
        this.connectionAcceptorRunnable = new LoopingRunnable((Runnable)((Object)connectionAcceptor));
        this.connectionAcceptorThread = new Thread((Runnable)this.connectionAcceptorRunnable, "uTP Connection Acceptor");
        this.channel = DatagramChannel.open();
        this.channel.bind(new InetSocketAddress(port));
        this.channel.configureBlocking(true);
        this.socketRegistry = new UtpSocketRegistry(this.channel);
        this.connectionAcceptorThread.start();
        LOGGER.trace("Configured to listen on {}", (Object)this.channel.getLocalAddress());
    }

    @Override
    public void run() {
        SocketAddress socketAddress;
        ByteBuffer buffer;
        try {
            buffer = ByteBuffer.allocate(32768);
            socketAddress = this.channel.receive(buffer);
            buffer.flip();
        }
        catch (IOException e) {
            LOGGER.error("Failed to read message.", (Throwable)e);
            return;
        }
        try {
            UtpSocket socket;
            UtpPacket packet = this.packetReader.read(buffer);
            if (packet.getHeader().getType() == PacketType.SYN.getTypeField()) {
                LOGGER.debug("Received connection with id [{}]", (Object)Short.toUnsignedInt(packet.getHeader().getConnectionId()));
                socket = this.socketRegistry.createSocket(socketAddress, packet);
                this.connectionAcceptor.onReceivedConnection(socket);
            } else {
                socket = this.socketRegistry.getSocket(packet.getHeader().getConnectionId());
            }
            socket.onReceivedPacket(packet);
        }
        catch (UtpProtocolViolationException e) {
            LOGGER.trace("uTP protocol was violated.", (Throwable)e);
        }
    }

    public ISocket createUnconnectedSocket() {
        return this.socketRegistry.allocateSocket(connectionId -> UtpSocket.createInitiatingSocket(this.channel, connectionId));
    }

    public void updateSockets() {
        try {
            for (UtpSocket socket : this.socketRegistry.getAllSockets()) {
                socket.processSendQueue();
                socket.processTimeout();
            }
            this.socketRegistry.removeShutdownSockets();
        }
        catch (Exception e) {
            LOGGER.warn("uTP socket caused exception", (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
        this.connectionAcceptorRunnable.stop();
        try {
            this.connectionAcceptorThread.interrupt();
            this.connectionAcceptorThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Interrupted while waiting for connection acceptor thread to shutdown.", (Throwable)e);
        }
    }
}

