/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.utp;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.internal.utils.Sync;
import org.johnnei.javatorrent.internal.utp.UtpSocket;
import org.johnnei.javatorrent.internal.utp.protocol.ConnectionState;
import org.johnnei.javatorrent.network.AbstractPeerConnectionAcceptor;
import org.johnnei.javatorrent.network.socket.ISocket;

public class UtpPeerConnectionAcceptor
extends AbstractPeerConnectionAcceptor {
    private final Lock notifyLock = new ReentrantLock();
    private final Condition onNewConnection = this.notifyLock.newCondition();
    private final Collection<UtpSocket> socketQueue = new LinkedList<UtpSocket>();

    public UtpPeerConnectionAcceptor(TorrentClient torrentClient) {
        super(torrentClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceivedConnection(UtpSocket socket) {
        UtpPeerConnectionAcceptor utpPeerConnectionAcceptor = this;
        synchronized (utpPeerConnectionAcceptor) {
            this.socketQueue.add(socket);
        }
        Sync.signalAll((Lock)this.notifyLock, (Condition)this.onNewConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISocket acceptSocket() throws IOException {
        Optional<UtpSocket> connectedSocket;
        this.notifyLock.lock();
        try {
            while (!this.hasPendingConnection()) {
                this.onNewConnection.await();
            }
            while (!(connectedSocket = this.getEstablishedConnection()).isPresent()) {
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for a new connection", e);
        }
        finally {
            this.notifyLock.unlock();
        }
        UtpPeerConnectionAcceptor utpPeerConnectionAcceptor = this;
        synchronized (utpPeerConnectionAcceptor) {
            this.socketQueue.remove(connectedSocket.get());
            return connectedSocket.get();
        }
    }

    private synchronized boolean hasPendingConnection() {
        return !this.socketQueue.isEmpty();
    }

    private synchronized Optional<UtpSocket> getEstablishedConnection() {
        return this.socketQueue.stream().filter(socket -> socket.getConnectionState() == ConnectionState.CONNECTED).findAny();
    }
}

