/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.utp;

import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import org.johnnei.javatorrent.internal.utp.UtpSocket;
import org.johnnei.javatorrent.internal.utp.protocol.UtpProtocolViolationException;
import org.johnnei.javatorrent.internal.utp.protocol.packet.UtpPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtpSocketRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(UtpSocketRegistry.class);
    private final Object createLock = new Object();
    private final DatagramChannel channel;
    private final Map<Short, UtpSocket> socketMap;
    private final Random random;

    public UtpSocketRegistry(DatagramChannel channel) {
        this.channel = channel;
        this.socketMap = new HashMap<Short, UtpSocket>();
        this.random = new Random();
    }

    public UtpSocket getSocket(short connectionId) {
        UtpSocket socket = this.socketMap.get(connectionId);
        if (socket == null) {
            throw new UtpProtocolViolationException(String.format("Packet received for [%s] but no socket has been registered.", Short.toUnsignedInt(connectionId)));
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UtpSocket allocateSocket(Function<Short, UtpSocket> socketSupplier) {
        Object object = this.createLock;
        synchronized (object) {
            UtpSocket socket = null;
            do {
                short receiveId;
                if (this.socketMap.containsKey(receiveId = (short)this.random.nextInt())) continue;
                socket = socketSupplier.apply(receiveId);
                LOGGER.trace("Registered initiated socket to receive on id [{}]", (Object)Short.toUnsignedInt(receiveId));
                this.socketMap.put(receiveId, socket);
            } while (socket == null);
            return socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UtpSocket createSocket(SocketAddress socketAddress, UtpPacket synPacket) {
        Object object = this.createLock;
        synchronized (object) {
            short receiveId = (short)(synPacket.getHeader().getConnectionId() + 1);
            if (this.socketMap.containsKey(receiveId)) {
                throw new UtpProtocolViolationException(String.format("Connection [%s] already registered before.", synPacket.getHeader().getConnectionId()));
            }
            UtpSocket socket = UtpSocket.createRemoteConnecting(this.channel, synPacket);
            socket.bind(socketAddress);
            LOGGER.trace("Registered received socket on to receive on id [{}] and send to [{}]", (Object)Short.toUnsignedInt(receiveId), (Object)socketAddress);
            this.socketMap.put(receiveId, socket);
            return socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<UtpSocket> getAllSockets() {
        Object object = this.createLock;
        synchronized (object) {
            return new ArrayList<UtpSocket>(this.socketMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShutdownSockets() {
        Object object = this.createLock;
        synchronized (object) {
            Iterator<Map.Entry<Short, UtpSocket>> iterator = this.socketMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Short, UtpSocket> socketEntry = iterator.next();
                UtpSocket socket = socketEntry.getValue();
                if (!socket.isShutdown()) continue;
                LOGGER.trace("Removed registration of socket with receive id [{}]", (Object)Short.toUnsignedInt(socketEntry.getKey()));
                iterator.remove();
            }
        }
    }
}

