/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.utp.protocol;

import java.nio.ByteBuffer;
import java.util.function.Function;
import org.johnnei.javatorrent.internal.utp.protocol.packet.DataPayload;
import org.johnnei.javatorrent.internal.utp.protocol.packet.FinPayload;
import org.johnnei.javatorrent.internal.utp.protocol.packet.Payload;
import org.johnnei.javatorrent.internal.utp.protocol.packet.ResetPayload;
import org.johnnei.javatorrent.internal.utp.protocol.packet.StatePayload;
import org.johnnei.javatorrent.internal.utp.protocol.packet.SynPayload;

public enum PacketType {
    DATA(0, data -> new DataPayload((ByteBuffer)data)),
    FIN(1, data -> new FinPayload()),
    STATE(2, data -> new StatePayload()),
    RESET(3, data -> new ResetPayload()),
    SYN(4, data -> new SynPayload());

    private final byte typeField;
    private final Function<ByteBuffer, Payload> payloadProducer;

    private PacketType(int typeField, Function<ByteBuffer, Payload> payloadProducer) {
        this.typeField = (byte)typeField;
        this.payloadProducer = payloadProducer;
    }

    public byte getTypeField() {
        return this.typeField;
    }

    public Payload createPayload(ByteBuffer data) {
        return this.payloadProducer.apply(data);
    }

    public static PacketType getByType(int typeField) {
        for (PacketType type : PacketType.values()) {
            if (type.typeField != typeField) continue;
            return type;
        }
        throw new IllegalArgumentException(String.format("No type is mapped for value %d", typeField));
    }
}

