/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.utp.protocol.packet;

public class UtpHeader {
    public static final byte IMPLEMENTED_VERSION = 1;
    private final byte type;
    private final byte version;
    private final byte extension;
    private final short connectionId;
    private final int windowSize;
    private final short sequenceNumber;
    private int timestamp;
    private int timestampDifference;
    private short acknowledgeNumber;

    private UtpHeader(Builder builder) {
        this.type = builder.type;
        this.version = 1;
        this.extension = builder.extension;
        this.connectionId = builder.connectionId;
        this.timestamp = builder.timestamp;
        this.timestampDifference = builder.timestampDifference;
        this.windowSize = builder.windowSize;
        this.sequenceNumber = builder.sequenceNumber;
        this.acknowledgeNumber = builder.acknowledgeNumber;
    }

    public void renew(short acknowledgeNumber, int timestamp, int timestampDifference) {
        this.acknowledgeNumber = acknowledgeNumber;
        this.timestamp = timestamp;
        this.timestampDifference = timestampDifference;
    }

    public byte getType() {
        return this.type;
    }

    public byte getVersion() {
        return this.version;
    }

    public byte getExtension() {
        return this.extension;
    }

    public short getConnectionId() {
        return this.connectionId;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public int getTimestampDifference() {
        return this.timestampDifference;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public short getSequenceNumber() {
        return this.sequenceNumber;
    }

    public short getAcknowledgeNumber() {
        return this.acknowledgeNumber;
    }

    public static final class Builder {
        private byte type;
        private byte extension;
        private short connectionId;
        private int timestamp;
        private int timestampDifference;
        private int windowSize;
        private short sequenceNumber;
        private short acknowledgeNumber;

        public Builder setType(byte type) {
            this.type = type;
            return this;
        }

        public Builder setExtension(byte extension) {
            this.extension = extension;
            return this;
        }

        public Builder setConnectionId(short connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public Builder setTimestamp(int timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setTimestampDifference(int timestampDifference) {
            this.timestampDifference = timestampDifference;
            return this;
        }

        public Builder setWindowSize(int windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        public Builder setSequenceNumber(short sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public Builder setAcknowledgeNumber(short acknowledgeNumber) {
            this.acknowledgeNumber = acknowledgeNumber;
            return this;
        }

        public UtpHeader build() {
            return new UtpHeader(this);
        }
    }
}

