/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.utp.protocol.packet;

import org.johnnei.javatorrent.internal.utp.protocol.packet.Payload;
import org.johnnei.javatorrent.internal.utp.protocol.packet.UtpHeader;

public class UtpPacket {
    private final UtpHeader header;
    private final Payload payload;
    private int timesSent;

    public UtpPacket(UtpHeader header, Payload payload) {
        assert (header.getType() == payload.getType().getTypeField()) : "Payload type doesn't confirm to the information in header.";
        this.header = header;
        this.payload = payload;
    }

    public UtpHeader getHeader() {
        return this.header;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public boolean isSendOnce() {
        return this.timesSent == 1;
    }

    public void incrementSentCount() {
        ++this.timesSent;
    }

    public int getSize() {
        return 20 + this.payload.getData().length;
    }
}

