/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.utp.stream;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class UtpInputStream
extends InputStream {
    private short nextSequenceNumber;
    private Map<Short, ByteBuffer> sequenceToBuffer;

    public UtpInputStream(short nextSequenceNumber) {
        this.nextSequenceNumber = nextSequenceNumber;
        this.sequenceToBuffer = new HashMap<Short, ByteBuffer>();
    }

    public void submitData(short sequenceNumber, byte[] data) {
        this.sequenceToBuffer.put(sequenceNumber, ByteBuffer.wrap(data));
    }

    @Override
    public int available() {
        int available = 0;
        short sequenceNumber = this.nextSequenceNumber;
        while (this.sequenceToBuffer.containsKey(sequenceNumber)) {
            available += this.sequenceToBuffer.get(sequenceNumber).remaining();
            sequenceNumber = (short)(sequenceNumber + 1);
        }
        return available;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int read;
        int readFromBuffer;
        for (read = 0; read < len && this.sequenceToBuffer.containsKey(this.nextSequenceNumber); read += readFromBuffer) {
            ByteBuffer buffer = this.sequenceToBuffer.get(this.nextSequenceNumber);
            readFromBuffer = Math.min(len - read, buffer.remaining());
            buffer.get(b, off + read, readFromBuffer);
            this.consumedFromBuffer(buffer);
        }
        return read;
    }

    @Override
    public int read() {
        ByteBuffer buffer = this.sequenceToBuffer.get(this.nextSequenceNumber);
        byte b = buffer.get();
        this.consumedFromBuffer(buffer);
        return b;
    }

    public void consumedFromBuffer(ByteBuffer buffer) {
        if (buffer.remaining() == 0) {
            this.sequenceToBuffer.remove(this.nextSequenceNumber);
            this.nextSequenceNumber = (short)(this.nextSequenceNumber + 1);
        }
    }

    public boolean isCompleteUntil(short sequenceNumber) {
        if (this.nextSequenceNumber == sequenceNumber) {
            return true;
        }
        for (short seq = this.nextSequenceNumber; seq < sequenceNumber; seq = (short)(seq + 1)) {
            if (this.sequenceToBuffer.containsKey(seq)) continue;
            return false;
        }
        return true;
    }
}

