/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.utp.stream;

import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import org.johnnei.javatorrent.internal.utp.UtpSocket;
import org.johnnei.javatorrent.internal.utp.protocol.UtpProtocolViolationException;

public class UtpOutputStream
extends OutputStream {
    private UtpSocket socket;
    private Queue<ByteBuffer> bufferedData;

    public UtpOutputStream(UtpSocket socket) {
        this.socket = socket;
        this.bufferedData = new LinkedList<ByteBuffer>();
    }

    @Override
    public void write(int b) {
        if (this.socket.isOutputShutdown()) {
            throw new UtpProtocolViolationException("Socket is closing/closed and can no longer package new data.");
        }
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.put((byte)(b & 0xFF));
        buffer.flip();
        this.bufferedData.add(buffer);
        this.packgePayloads(false);
    }

    @Override
    public void write(byte[] b) {
        if (this.socket.isOutputShutdown()) {
            throw new UtpProtocolViolationException("Socket is closing/closed and can no longer package new data.");
        }
        this.bufferedData.add(ByteBuffer.wrap(b));
        this.packgePayloads(false);
    }

    @Override
    public void flush() {
        this.packgePayloads(true);
    }

    private void packgePayloads(boolean flush) {
        int payloadSize = this.socket.getPacketPayloadSize();
        while (this.hasEnoughBufferedData(payloadSize, flush)) {
            ByteBuffer payloadBuffer = this.createPayloadBuffer(Math.min(payloadSize, this.countBufferedBytes()));
            this.socket.send(payloadBuffer);
            payloadSize = this.socket.getPacketPayloadSize();
        }
    }

    private boolean hasEnoughBufferedData(int payloadSize, boolean flush) {
        return !this.bufferedData.isEmpty() && (flush || this.countBufferedBytes() >= payloadSize);
    }

    private ByteBuffer createPayloadBuffer(int payloadSize) {
        ByteBuffer payloadBuffer = ByteBuffer.allocate(payloadSize);
        while (payloadBuffer.hasRemaining()) {
            ByteBuffer buffer = this.bufferedData.peek();
            buffer.limit(Math.min(buffer.remaining(), payloadBuffer.remaining()));
            payloadBuffer.put(buffer);
            buffer.limit(buffer.capacity());
            if (buffer.hasRemaining()) continue;
            this.bufferedData.poll();
        }
        payloadBuffer.flip();
        return payloadBuffer;
    }

    private int countBufferedBytes() {
        return this.bufferedData.stream().map(Buffer::remaining).reduce(0, (a, b) -> a + b);
    }
}

