/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.utp;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.async.LoopingRunnable;
import org.johnnei.javatorrent.internal.utp.UtpMultiplexer;
import org.johnnei.javatorrent.internal.utp.UtpPeerConnectionAcceptor;
import org.johnnei.javatorrent.internal.utp.UtpSocket;
import org.johnnei.javatorrent.internal.utp.stream.PacketReader;
import org.johnnei.javatorrent.module.IModule;
import org.johnnei.javatorrent.module.ModuleBuildException;
import org.johnnei.javatorrent.network.socket.ISocket;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.johnnei.javatorrent.utils.Argument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtpModule
implements IModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(UtpModule.class);
    private UtpMultiplexer multiplexer;
    private Thread workerThread;
    private LoopingRunnable multiplexerRunner;
    private ScheduledFuture<?> socketProcessorTask;
    private int listeningPort;

    private UtpModule(Builder builder) {
        this.listeningPort = builder.listeningPort;
    }

    public void configureTorrentClient(TorrentClient.Builder builder) {
    }

    public int getRelatedBep() {
        return 29;
    }

    public List<Class<IModule>> getDependsOn() {
        return Collections.emptyList();
    }

    public void onPostHandshake(Peer peer) throws IOException {
    }

    public void onBuild(TorrentClient torrentClient) throws ModuleBuildException {
        try {
            this.multiplexer = new UtpMultiplexer(new UtpPeerConnectionAcceptor(torrentClient), new PacketReader(), this.listeningPort);
            this.multiplexerRunner = new LoopingRunnable((Runnable)this.multiplexer);
            this.workerThread = new Thread((Runnable)this.multiplexerRunner, "uTP Packet Reader");
            this.workerThread.start();
            this.socketProcessorTask = torrentClient.getExecutorService().scheduleAtFixedRate(this.multiplexer::updateSockets, 0L, 100L, TimeUnit.MILLISECONDS);
        }
        catch (IOException e) {
            throw new ModuleBuildException("Failed to create uTP Multiplexer.", (Throwable)e);
        }
    }

    public void onShutdown() {
        this.multiplexerRunner.stop();
        try {
            this.multiplexer.close();
        }
        catch (IOException e) {
            LOGGER.warn("Failed to shutdown uTP Multiplexer", (Throwable)e);
        }
        try {
            this.workerThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Interrupted while waiting for uTP worker to exit.", (Throwable)e);
        }
        this.socketProcessorTask.cancel(true);
    }

    public Class<ISocket> getUtpSocketClass() {
        return UtpSocket.class;
    }

    public Supplier<ISocket> createSocketFactory() {
        return () -> this.multiplexer.createUnconnectedSocket();
    }

    public static final class Builder {
        private int listeningPort;

        public Builder listenOn(int port) {
            Argument.requireWithinBounds((int)port, (int)0, (int)32768, () -> "Port must be a valid port (0 >= x < 2^16)");
            this.listeningPort = port;
            return this;
        }

        public UtpModule build() {
            return new UtpModule(this);
        }
    }
}

