/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.encoding;

import java.util.Map;
import java.util.Optional;
import org.johnnei.javatorrent.bittorrent.encoding.BencodedMap;
import org.johnnei.javatorrent.bittorrent.encoding.IBencodedValue;
import org.johnnei.javatorrent.test.TestUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class BencodedMapTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testPut() throws Exception {
        BencodedMap cut = new BencodedMap();
        String key = "cow";
        TestUtils.assertNotPresent("Item available before added", cut.get(key));
        IBencodedValue valueMock = (IBencodedValue)Mockito.mock(IBencodedValue.class);
        cut.put(key, valueMock);
        Optional value = cut.get(key);
        TestUtils.assertPresent("Item must be available after adding", value);
        Assert.assertEquals((String)"Incorrect value was returned", (Object)valueMock, value.get());
    }

    @Test
    public void testPutOverwrite() throws Exception {
        BencodedMap cut = new BencodedMap();
        String key = "cow";
        TestUtils.assertNotPresent("Item available before added", cut.get(key));
        IBencodedValue valueMock = (IBencodedValue)Mockito.mock(IBencodedValue.class);
        cut.put(key, valueMock);
        Optional value = cut.get(key);
        TestUtils.assertPresent("Item must be available after adding", value);
        Assert.assertEquals((String)"Incorrect value was returned", (Object)valueMock, value.get());
        IBencodedValue valueMockTwo = (IBencodedValue)Mockito.mock(IBencodedValue.class);
        cut.put(key, valueMockTwo);
        value = cut.get(key);
        TestUtils.assertPresent("Item must be available after adding", value);
        Assert.assertEquals((String)"Incorrect value was returned after overwrite", (Object)valueMockTwo, value.get());
    }

    @Test
    public void testRemove() throws Exception {
        BencodedMap cut = new BencodedMap();
        String key = "cow";
        TestUtils.assertNotPresent("Item available before added", cut.get(key));
        TestUtils.assertNotPresent("An item was removed before adding anything", cut.remove(key));
        IBencodedValue valueMock = (IBencodedValue)Mockito.mock(IBencodedValue.class);
        cut.put(key, valueMock);
        TestUtils.assertPresent("Item must be available after adding", cut.get(key));
        Optional value = cut.remove(key);
        TestUtils.assertPresent("Value must have been removed.", value);
        Assert.assertEquals((String)"Incorrect item was removed", (Object)valueMock, value.get());
    }

    @Test
    public void testAsString() throws Exception {
        this.thrown.expect(UnsupportedOperationException.class);
        new BencodedMap().asString();
    }

    @Test
    public void testAsLong() throws Exception {
        this.thrown.expect(UnsupportedOperationException.class);
        new BencodedMap().asLong();
    }

    @Test
    public void testAsBigInteger() throws Exception {
        this.thrown.expect(UnsupportedOperationException.class);
        new BencodedMap().asBigInteger();
    }

    @Test
    public void testAsMap() throws Exception {
        BencodedMap cut = new BencodedMap();
        String key = "cow";
        TestUtils.assertNotPresent("Item available before added", cut.get(key));
        IBencodedValue valueMock = (IBencodedValue)Mockito.mock(IBencodedValue.class);
        cut.put(key, valueMock);
        Optional value = cut.get(key);
        TestUtils.assertPresent("Item must be available after adding", value);
        Assert.assertEquals((String)"Incorrect value was returned", (Object)valueMock, value.get());
        Map map = cut.asMap();
        Assert.assertEquals((String)"Incorrect amount of items in map copy", (long)1L, (long)map.size());
        Assert.assertEquals((String)"Incorrect value in map copy", (Object)valueMock, map.get("cow"));
    }

    @Test
    public void testAsList() throws Exception {
        this.thrown.expect(UnsupportedOperationException.class);
        new BencodedMap().asList();
    }

    @Test
    public void testSerialize() throws Exception {
        BencodedMap cut = new BencodedMap();
        IBencodedValue valueMock = (IBencodedValue)Mockito.mock(IBencodedValue.class);
        IBencodedValue valueMockTwo = (IBencodedValue)Mockito.mock(IBencodedValue.class);
        Mockito.when((Object)valueMock.serialize()).thenReturn((Object)"3:moo");
        Mockito.when((Object)valueMockTwo.serialize()).thenReturn((Object)"4:eggs");
        cut.put("cow", valueMock);
        cut.put("spam", valueMockTwo);
        Assert.assertEquals((String)"Incorrect serialized form", (Object)"d3:cow3:moo4:spam4:eggse", (Object)cut.serialize());
    }

    @Test
    public void testSerializeSortRawBytes() throws Exception {
        BencodedMap cut = new BencodedMap();
        IBencodedValue valueMock = (IBencodedValue)Mockito.mock(IBencodedValue.class);
        IBencodedValue valueMockTwo = (IBencodedValue)Mockito.mock(IBencodedValue.class);
        Mockito.when((Object)valueMock.serialize()).thenReturn((Object)"4:eggs");
        Mockito.when((Object)valueMockTwo.serialize()).thenReturn((Object)"3:moo");
        cut.put("cow", valueMock);
        cut.put("Cow", valueMockTwo);
        Assert.assertEquals((String)"Incorrect serialized form", (Object)"d3:Cow3:moo3:cow4:eggse", (Object)cut.serialize());
    }

    @Test
    public void testSerializeAddIncorrectOrder() throws Exception {
        BencodedMap cut = new BencodedMap();
        IBencodedValue valueMock = (IBencodedValue)Mockito.mock(IBencodedValue.class);
        IBencodedValue valueMockTwo = (IBencodedValue)Mockito.mock(IBencodedValue.class);
        Mockito.when((Object)valueMock.serialize()).thenReturn((Object)"3:moo");
        Mockito.when((Object)valueMockTwo.serialize()).thenReturn((Object)"4:eggs");
        cut.put("spam", valueMockTwo);
        cut.put("cow", valueMock);
        Assert.assertEquals((String)"Incorrect serialized form", (Object)"d3:cow3:moo4:spam4:eggse", (Object)cut.serialize());
    }
}

