/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.protocol;

import org.johnnei.javatorrent.bittorrent.protocol.MessageFactory;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageBitfield;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageBlock;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageCancel;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageChoke;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageHave;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageInterested;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageRequest;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageUnchoke;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageUninterested;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class MessageFactoryTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testBuildRegistersBitTorrentMessages() {
        MessageFactory cut = new MessageFactory.Builder().build();
        Assert.assertEquals((String)"Incorrect message class for message ID 0", MessageChoke.class, cut.createById(0).getClass());
        Assert.assertEquals((String)"Incorrect message class for message ID 1", MessageUnchoke.class, cut.createById(1).getClass());
        Assert.assertEquals((String)"Incorrect message class for message ID 2", MessageInterested.class, cut.createById(2).getClass());
        Assert.assertEquals((String)"Incorrect message class for message ID 3", MessageUninterested.class, cut.createById(3).getClass());
        Assert.assertEquals((String)"Incorrect message class for message ID 4", MessageHave.class, cut.createById(4).getClass());
        Assert.assertEquals((String)"Incorrect message class for message ID 5", MessageBitfield.class, cut.createById(5).getClass());
        Assert.assertEquals((String)"Incorrect message class for message ID 6", MessageRequest.class, cut.createById(6).getClass());
        Assert.assertEquals((String)"Incorrect message class for message ID 7", MessageBlock.class, cut.createById(7).getClass());
        Assert.assertEquals((String)"Incorrect message class for message ID 8", MessageCancel.class, cut.createById(8).getClass());
    }

    @Test
    public void testErrorOnInvalidId() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Message 9");
        MessageFactory cut = new MessageFactory.Builder().build();
        cut.createById(9);
    }

    @Test
    public void testErrorOnOverrideMessage() {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Failed to add message");
        new MessageFactory.Builder().registerMessage(4, MessageBlock::new);
    }
}

