/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.protocol.messages;

import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.EasyMockSupport;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageBitfield;
import org.johnnei.javatorrent.network.InStream;
import org.johnnei.javatorrent.network.OutStream;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class MessageBitfieldTest
extends EasyMockSupport {
    @Test
    public void testWrite() {
        byte[] expectedBytes = new byte[]{1, 9, 3};
        OutStream outStream = new OutStream();
        MessageBitfield cut = new MessageBitfield(expectedBytes);
        cut.write(outStream);
        Assert.assertEquals((String)"Incorrect message length", (long)(1 + expectedBytes.length), (long)cut.getLength());
        Assert.assertArrayEquals((String)"Incorrect output", (byte[])expectedBytes, (byte[])outStream.toByteArray());
        Assert.assertEquals((String)"Incorrect message ID", (long)5L, (long)cut.getId());
        Assert.assertTrue((String)"Incorrect toString start.", (boolean)cut.toString().startsWith("MessageBitfield["));
    }

    @Test
    public void testReadAndProcess() {
        int i;
        byte[] input = new byte[]{-1, 0, 15};
        InStream inStream = new InStream(input);
        Peer peerMock = (Peer)this.createMock(Peer.class);
        MessageBitfield cut = new MessageBitfield();
        cut.read(inStream);
        for (i = 0; i < 8; ++i) {
            peerMock.setHavingPiece(EasyMock.eq((int)i));
        }
        for (i = 0; i < 4; ++i) {
            peerMock.setHavingPiece(EasyMock.eq((int)(20 + i)));
        }
        this.replayAll();
        cut.process(peerMock);
        this.verifyAll();
    }
}

