/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.protocol.messages;

import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.EasyMockSupport;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageRequest;
import org.johnnei.javatorrent.network.BitTorrentSocket;
import org.johnnei.javatorrent.network.InStream;
import org.johnnei.javatorrent.network.OutStream;
import org.johnnei.javatorrent.torrent.AbstractFileSet;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.johnnei.javatorrent.torrent.peer.PeerDirection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class MessageRequestTest
extends EasyMockSupport {
    @Test
    public void testWrite() {
        byte[] expectedBytes = new byte[]{0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 3};
        OutStream outStream = new OutStream();
        MessageRequest cut = new MessageRequest(1, 2, 3);
        cut.write(outStream);
        Assert.assertEquals((String)"Incorrect message length", (long)(1 + expectedBytes.length), (long)cut.getLength());
        Assert.assertArrayEquals((String)"Incorrect output", (byte[])expectedBytes, (byte[])outStream.toByteArray());
        Assert.assertEquals((String)"Incorrect message ID", (long)6L, (long)cut.getId());
        Assert.assertTrue((String)"Incorrect toString start.", (boolean)cut.toString().startsWith("MessageRequest["));
    }

    @Test
    public void testReadAndProcess() {
        InStream inStream = new InStream(new byte[]{0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 3});
        Peer peerMock = (Peer)this.createMock(Peer.class);
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        AbstractFileSet filesMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)peerMock.getTorrent()).andStubReturn((Object)torrentMock);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)filesMock);
        EasyMock.expect((Object)filesMock.hasPiece(EasyMock.eq((int)1))).andReturn((Object)true);
        peerMock.addBlockRequest(EasyMock.eq((int)1), EasyMock.eq((int)2), EasyMock.eq((int)3), (PeerDirection)EasyMock.eq((Object)PeerDirection.Upload));
        this.replayAll();
        MessageRequest cut = new MessageRequest();
        cut.read(inStream);
        cut.process(peerMock);
        this.verifyAll();
    }

    @Test
    public void testReadAndProcessNotHavingPiece() {
        InStream inStream = new InStream(new byte[]{0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 3});
        Peer peerMock = (Peer)this.createMock(Peer.class);
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        AbstractFileSet filesMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        EasyMock.expect((Object)peerMock.getTorrent()).andStubReturn((Object)torrentMock);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)filesMock);
        EasyMock.expect((Object)filesMock.hasPiece(EasyMock.eq((int)1))).andReturn((Object)false);
        EasyMock.expect((Object)peerMock.getBitTorrentSocket()).andStubReturn((Object)socketMock);
        socketMock.close();
        this.replayAll();
        MessageRequest cut = new MessageRequest();
        cut.read(inStream);
        cut.process(peerMock);
        this.verifyAll();
    }
}

