/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.tracker;

import java.time.Clock;
import java.time.Duration;
import org.johnnei.javatorrent.bittorrent.tracker.TorrentInfo;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerEvent;
import org.johnnei.javatorrent.test.DummyEntity;
import org.johnnei.javatorrent.test.TestClock;
import org.johnnei.javatorrent.torrent.Torrent;
import org.junit.Assert;
import org.junit.Test;

public class TorrentInfoTest {
    @Test
    public void testSetInfoAnnounce() {
        Torrent torrent = DummyEntity.createUniqueTorrent(new Torrent[0]);
        Clock baseClock = Clock.fixed(Clock.systemDefaultZone().instant(), Clock.systemDefaultZone().getZone());
        Clock offsetClock = Clock.offset(baseClock, Duration.ofSeconds(3L));
        TestClock testClock = new TestClock(baseClock);
        TorrentInfo cut = new TorrentInfo(torrent, (Clock)testClock);
        testClock.setClock(offsetClock);
        cut.setInfo(15, 42);
        Assert.assertEquals((String)"Seeder count should have been 15", (long)15L, (long)cut.getSeeders());
        Assert.assertEquals((String)"Leechers count should have been 42", (long)42L, (long)cut.getLeechers());
        Assert.assertEquals((String)"Duration since last announce should have been zero", (Object)Duration.ZERO, (Object)cut.getTimeSinceLastAnnounce());
    }

    @Test
    public void testSetInfoScrape() {
        Torrent torrent = DummyEntity.createUniqueTorrent(new Torrent[0]);
        TorrentInfo cut = new TorrentInfo(torrent, Clock.systemDefaultZone());
        Assert.assertEquals((String)"Download count should have been 0 causing N/A", (Object)"N/A", (Object)cut.getDownloadCount());
        cut.setInfo(15, 42, 10);
        Assert.assertEquals((String)"Seeder count should have been 15", (long)15L, (long)cut.getSeeders());
        Assert.assertEquals((String)"Leechers count should have been 42", (long)42L, (long)cut.getLeechers());
        Assert.assertEquals((String)"Download count should have been 10", (Object)"10", (Object)cut.getDownloadCount());
    }

    @Test
    public void testGettersAndSetters() {
        Torrent torrent = DummyEntity.createUniqueTorrent(new Torrent[0]);
        TorrentInfo cut = new TorrentInfo(torrent, Clock.systemDefaultZone());
        Assert.assertEquals((String)"Torrent should be the same as the given one in the constructor", (Object)torrent, (Object)cut.getTorrent());
        Assert.assertEquals((String)"Initial tracker event should be STARTED", (Object)TrackerEvent.EVENT_STARTED, (Object)cut.getEvent());
        cut.setEvent(TrackerEvent.EVENT_COMPLETED);
        Assert.assertEquals((String)"Event should have changed by set.", (Object)TrackerEvent.EVENT_COMPLETED, (Object)cut.getEvent());
    }
}

