/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.tracker;

import java.util.Optional;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.bittorrent.tracker.ITracker;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerException;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerFactory;
import org.johnnei.javatorrent.test.DummyEntity;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.utils.CheckedBiFunction;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TrackerFactoryTest
extends EasyMockSupport {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testBuildFailureOnNoProtocols() {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("At least one tracker protocol");
        new TrackerFactory.Builder().build();
    }

    @Test
    public void testBuildFailureOnNoTorrentClient() {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Torrent client");
        ITracker trackerMock = (ITracker)this.createMock(ITracker.class);
        this.replayAll();
        try {
            new TrackerFactory.Builder().registerProtocol("udp", (url, client) -> trackerMock).build();
        }
        finally {
            this.verifyAll();
        }
    }

    @Test
    public void testBuildOverrideProtocol() {
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        ITracker trackerMock = (ITracker)this.createMock(ITracker.class);
        ITracker trackerMockTwo = (ITracker)this.createMock(ITracker.class);
        this.replayAll();
        TrackerFactory cut = new TrackerFactory.Builder().setTorrentClient(torrentClientMock).registerProtocol("udp", (url, client) -> trackerMock).registerProtocol("udp", (url, client) -> trackerMockTwo).build();
        Optional result = cut.getTrackerFor("udp://localhost:80");
        this.verifyAll();
        Assert.assertTrue((String)"Tracker should have been present", (boolean)result.isPresent());
        Assert.assertEquals((String)"Incorrect tracker has been returned", (Object)trackerMockTwo, result.get());
    }

    @Test
    public void testToString() {
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        ITracker trackerMock = (ITracker)this.createMock(ITracker.class);
        this.replayAll();
        TrackerFactory cut = new TrackerFactory.Builder().setTorrentClient(torrentClientMock).registerProtocol("udp", (url, client) -> trackerMock).build();
        String result = cut.toString();
        this.verifyAll();
        Assert.assertTrue((boolean)result.startsWith("TrackerFactory["));
    }

    @Test
    public void testGetTrackersHavingTorrent() throws Exception {
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        ITracker trackerMock = (ITracker)this.createMock(ITracker.class);
        Torrent torrent = DummyEntity.createUniqueTorrent(new Torrent[0]);
        EasyMock.expect((Object)trackerMock.hasTorrent((Torrent)EasyMock.eq((Object)torrent))).andReturn((Object)false);
        EasyMock.expect((Object)trackerMock.hasTorrent((Torrent)EasyMock.eq((Object)torrent))).andReturn((Object)true);
        this.replayAll();
        TrackerFactory cut = new TrackerFactory.Builder().setTorrentClient(torrentClientMock).registerProtocol("udp", (url, client) -> trackerMock).build();
        Optional tracker = cut.getTrackerFor("udp://localhost:80");
        Assert.assertTrue((String)"Tracker should have been added", (boolean)tracker.isPresent());
        Assert.assertEquals((String)"No tracker should have the given torrent", (long)0L, (long)cut.getTrackersHavingTorrent(torrent).size());
        Assert.assertEquals((String)"No tracker should have the given torrent", (long)1L, (long)cut.getTrackersHavingTorrent(torrent).size());
        this.verifyAll();
    }

    @Test
    public void testGetTrackerFor() {
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        ITracker trackerMock = (ITracker)this.createMock(ITracker.class);
        this.replayAll();
        TrackerFactory cut = new TrackerFactory.Builder().setTorrentClient(torrentClientMock).registerProtocol("udp", (url, client) -> trackerMock).build();
        Optional result = cut.getTrackerFor("udp://localhost:80");
        this.verifyAll();
        Assert.assertTrue((String)"Tracker should have been present", (boolean)result.isPresent());
        Assert.assertEquals((String)"Incorrect tracker has been returned", (Object)trackerMock, result.get());
    }

    @Test
    public void testGetTrackerForException() {
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        this.replayAll();
        TrackerFactory cut = new TrackerFactory.Builder().setTorrentClient(torrentClientMock).registerProtocol("udp", (url, client) -> {
            throw new TrackerException("Test");
        }).build();
        Optional result = cut.getTrackerFor("udp://localhost:80");
        this.verifyAll();
        Assert.assertFalse((String)"Tracker should have been present", (boolean)result.isPresent());
    }

    @Test
    public void testGetTrackerForCaching() throws Exception {
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        ITracker trackerMock = (ITracker)this.createMock(ITracker.class);
        String trackerUrl = "udp://localhost:80";
        CheckedBiFunction supplierMock = (CheckedBiFunction)this.createMock(CheckedBiFunction.class);
        EasyMock.expect((Object)supplierMock.apply(EasyMock.eq((Object)"udp://localhost:80"), EasyMock.same((Object)torrentClientMock))).andReturn((Object)trackerMock);
        this.replayAll();
        TrackerFactory cut = new TrackerFactory.Builder().setTorrentClient(torrentClientMock).registerProtocol("udp", supplierMock).build();
        Optional result = cut.getTrackerFor("udp://localhost:80");
        Optional resultTwo = cut.getTrackerFor("udp://localhost:80");
        this.verifyAll();
        Assert.assertTrue((String)"Tracker should have been present", (boolean)result.isPresent());
        Assert.assertTrue((String)"Second tracker should have been present", (boolean)resultTwo.isPresent());
        Assert.assertEquals((String)"Incorrect tracker has been returned", (Object)trackerMock, result.get());
        Assert.assertTrue((String)"Trackers should have been the same instance", (resultTwo.get() == result.get() ? 1 : 0) != 0);
    }

    @Test
    public void testGetTrackerForInvalidUrl() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("protocol definition");
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        ITracker trackerMock = (ITracker)this.createMock(ITracker.class);
        this.replayAll();
        TrackerFactory cut = new TrackerFactory.Builder().setTorrentClient(torrentClientMock).registerProtocol("udp", (url, client) -> trackerMock).build();
        cut.getTrackerFor("not_a_valid_url");
        this.verifyAll();
    }

    @Test
    public void testGetTrackerForUnknownProtocol() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Unsupported protocol");
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        ITracker trackerMock = (ITracker)this.createMock(ITracker.class);
        this.replayAll();
        TrackerFactory cut = new TrackerFactory.Builder().setTorrentClient(torrentClientMock).registerProtocol("udp", (url, client) -> trackerMock).build();
        cut.getTrackerFor("http://example.com");
        this.verifyAll();
    }
}

