/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.disk;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.johnnei.javatorrent.disk.DiskJobCheckHash;
import org.johnnei.javatorrent.test.StubEntity;
import org.johnnei.javatorrent.torrent.AbstractFileSet;
import org.johnnei.javatorrent.torrent.FileInfo;
import org.johnnei.javatorrent.torrent.files.Piece;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskJobCheckHashTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskJobCheckHashTest.class);
    private CountDownLatch countDownLatch;
    private final File testFile;
    private final long testFileSize;
    private final File testFileMismatch;
    private final long testFileMismatchSize;
    private final byte[] expectedHash = new byte[]{17, -5, -105, 12, -2, -114, -51, -119, -81, -89, 80, -48, 100, 84, -36, -47, 96, -41, 94, 25};

    public DiskJobCheckHashTest() throws Exception {
        this.testFile = new File(DiskJobCheckHashTest.class.getResource("checkhashfile.txt").toURI());
        this.testFileSize = this.testFile.length();
        this.testFileMismatch = new File(DiskJobCheckHashTest.class.getResource("checkhashfile-mismatch.txt").toURI());
        this.testFileMismatchSize = this.testFileMismatch.length();
    }

    @Before
    public void setUp() {
        this.countDownLatch = new CountDownLatch(1);
        LOGGER.info("Correct hash file: {} bytes", (Object)this.testFileSize);
        LOGGER.info("Mismatch hash file: {} bytes", (Object)this.testFileMismatchSize);
    }

    @Test
    public void testMatchingHash() throws Exception {
        FileInfo fileInfo = new FileInfo(this.testFileSize, 0L, this.testFile, 1);
        AbstractFileSet filesStub = StubEntity.stubAFiles(1, fileInfo, (int)this.testFileSize);
        Piece piece = new Piece(filesStub, this.expectedHash, 0, (int)this.testFileSize, (int)this.testFileSize);
        DiskJobCheckHash cut = new DiskJobCheckHash(piece, x -> this.countDownLatch.countDown());
        cut.process();
        this.countDownLatch.await(5L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Hash should have matched.", (boolean)cut.isMatchingHash());
    }

    @Test
    public void testNonMatchingHash() throws Exception {
        FileInfo fileInfo = new FileInfo(this.testFileSize, 0L, this.testFileMismatch, 1);
        AbstractFileSet filesStub = StubEntity.stubAFiles(1, fileInfo, (int)this.testFileSize);
        Piece piece = new Piece(filesStub, this.expectedHash, 0, (int)this.testFileSize, (int)this.testFileSize);
        DiskJobCheckHash cut = new DiskJobCheckHash(piece, x -> this.countDownLatch.countDown());
        cut.process();
        this.countDownLatch.await(5L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"Hash should not have matched.", (boolean)cut.isMatchingHash());
    }

    @Test
    public void testStaticMethods() {
        Piece piece = new Piece(null, null, 0, 1, 1);
        DiskJobCheckHash cut = new DiskJobCheckHash(piece, x -> {});
        Assert.assertEquals((String)"Incorrect piece", (Object)piece, (Object)cut.getPiece());
        Assert.assertEquals((String)"Incorrect priority", (long)3L, (long)cut.getPriority());
    }
}

